/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.pipeline;

import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipeline.class);
    private static final PipeData.Topic<List<PipelineComponent>> PIPELINE_EXTENSION = new PipeData.Topic(Pipeline.class.getName() + ".extended");
    private static final PipeData.Topic<Boolean> PIPELINE_CLOSED = new PipeData.Topic(Pipeline.class.getName() + ".closed");
    private static final PipeData.Topic<String> PIPELINE_LAST_COMPONENT = new PipeData.Topic(Pipeline.class.getName() + ".component.last");
    private static final List<PipelineComponent> EMPTY_COMPONENT_LIST = Collections.emptyList();
    private final List<PipelineComponent> components;

    private Pipeline(List<PipelineComponent> components) {
        this.components = components;
    }

    public static Pipeline of(PipelineComponent ... components) {
        return new Pipeline(Arrays.asList((Object[])Preconditions.checkNotNull((Object)components)));
    }

    public static Pipeline of(Iterable<PipelineComponent> components) {
        return new Pipeline((List<PipelineComponent>)ImmutableList.copyOf(components));
    }

    public PipeData run(PipeData initialInput) {
        LinkedList<PipelineComponent> pipeline = new LinkedList<PipelineComponent>(this.components);
        PipeData data = (PipeData)Preconditions.checkNotNull((Object)initialInput);
        LOGGER.trace("Opened: <pending_components_number={}>", (Object)pipeline.size());
        while (!pipeline.isEmpty() && !this.isPipelineClosed(data)) {
            PipelineComponent component = (PipelineComponent)pipeline.remove();
            String componentName = this.getComponentName(component);
            data = this.dropComponentName(data);
            LOGGER.debug("Executing: <component={}> on <input={}>", (Object)componentName, (Object)data);
            data = this.transformPipeline(pipeline, component.process(data));
            LOGGER.trace("Finished: <component={}> with <output={}>", (Object)componentName, (Object)data);
            data = this.addComponentName(data, componentName);
            LOGGER.trace("Remaining: <pending_components_number={}>", (Object)pipeline.size());
        }
        LOGGER.trace("Closed: <pending_components_number={}>", (Object)pipeline.size());
        return this.dropComponentName(data);
    }

    private PipeData dropComponentName(PipeData pipeData) {
        return PipeData.use(pipeData).drop(PIPELINE_LAST_COMPONENT).toPipe();
    }

    private PipeData addComponentName(PipeData pipeData, String componentName) {
        return PipeData.use(pipeData).put(PIPELINE_LAST_COMPONENT, componentName).toPipe();
    }

    private String getComponentName(PipelineComponent component) {
        Class<?> aClass = component.getClass();
        return StringUtils.isBlank((CharSequence)aClass.getSimpleName()) ? aClass.getName() : aClass.getSimpleName();
    }

    private boolean isPipelineClosed(PipeData data) {
        Boolean isClosed = (Boolean)data.get(PIPELINE_CLOSED).or((Object)false);
        if (isClosed.booleanValue()) {
            LOGGER.debug("Closing: <component_requsting_close={}>", data.get(PIPELINE_LAST_COMPONENT).or((Object)""));
        }
        return isClosed;
    }

    private PipeData transformPipeline(Queue<PipelineComponent> pipeline, PipeData output) {
        List pipelineExtension = (List)output.get(PIPELINE_EXTENSION).or(EMPTY_COMPONENT_LIST);
        LOGGER.trace("Extended: <new_component_number={}> <new_components={}>", (Object)pipelineExtension.size(), (Object)pipelineExtension);
        pipeline.addAll(pipelineExtension);
        return PipeData.use(output).drop(PIPELINE_EXTENSION).toPipe();
    }

    public static PipeData streamClosed() {
        return Pipeline.streamClosed(PipeData.empty().toPipe());
    }

    public static PipeData streamClosed(PipeData pipelineOutput) {
        return PipeData.use(pipelineOutput).put(PIPELINE_CLOSED, true).toPipe();
    }

    public static FlowController emitPipelineExtensionBy(PipelineComponent ... componentsToAdd) {
        return new FlowController(Arrays.asList(componentsToAdd));
    }

    public static final class FlowController {
        private List<PipelineComponent> components;
        private PipeData output = PipeData.empty().toPipe();

        private FlowController(List<PipelineComponent> components) {
            this.components = ImmutableList.copyOf(components);
        }

        public FlowController extending(PipelineComponent ... componentsToAdd) {
            this.components = ImmutableList.copyOf((Iterable)Iterables.concat(this.components, Arrays.asList((Object[])Preconditions.checkNotNull((Object)componentsToAdd))));
            return this;
        }

        public FlowController outputting(PipeData output) {
            this.output = output;
            return this;
        }

        public PipeData toPipe() {
            return PipeData.use(this.output).put(PIPELINE_EXTENSION, this.components).toPipe();
        }
    }
}

