/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile;

import com.adobe.granite.crx2oak.profile.merge.ProfileMerger;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.parse.Parser;
import com.adobe.granite.crx2oak.profile.parse.ProfileParserFactory;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class ProfileChainMerger {
    private ProfileMerger profileMerger;
    private Parser<RawProfileTemplate, CommandLineProfileTemplate> profileTemplateParser;

    public ProfileChainMerger(ProfileMerger profileMerger, ProfileParserFactory profileParserFactory) {
        this.profileMerger = (ProfileMerger)Preconditions.checkNotNull((Object)profileMerger);
        this.profileTemplateParser = (Parser)Preconditions.checkNotNull(profileParserFactory.createProfileTemplateParser());
    }

    public Optional<CommandLineProfileTemplate> merge(Iterable<CommandLineProfileTemplate> commandLineProfileTemplates) {
        Optional optionalMergedProfileTemplate = Optional.absent();
        for (CommandLineProfileTemplate profileToMerge : commandLineProfileTemplates) {
            optionalMergedProfileTemplate = optionalMergedProfileTemplate.isPresent() ? Optional.of((Object)this.mergeAndParse((CommandLineProfileTemplate)optionalMergedProfileTemplate.get(), profileToMerge)) : Optional.of((Object)profileToMerge);
        }
        return optionalMergedProfileTemplate;
    }

    private CommandLineProfileTemplate mergeAndParse(CommandLineProfileTemplate baseProfile, CommandLineProfileTemplate profileToMerge) {
        RawProfileTemplate merge = this.profileMerger.merge(baseProfile, profileToMerge);
        return this.profileTemplateParser.parse(merge);
    }
}

