/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.profile.TagsProvider;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.profile.CommandLineProfile;
import com.adobe.granite.crx2oak.profile.model.profile.RawProfile;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.normalize.ProfileNormalizer;
import com.adobe.granite.crx2oak.profile.parse.Parser;
import com.adobe.granite.crx2oak.profile.parse.ProfileParserFactory;
import com.adobe.granite.crx2oak.profile.process.ProfileProcessor;
import com.adobe.granite.crx2oak.profile.save.ProfileWriter;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileHandler.class);
    private final List<TagsProvider> tagsProviders;
    private final Parser<RawProfile, CommandLineProfile> profileParser;
    private final ProfileWriter profileWriter;
    private final ProfileProcessor profileProcessor;
    private final ProfileNormalizer saveProfileNormalizer;

    public ProfileHandler(ProfileParserFactory profileParserFactory, ProfileWriter profileWriter, ProfileProcessor profileProcessor, List<TagsProvider> tagsProviders, @Nonnull ProfileNormalizer saveProfileNormalizer) {
        this.profileParser = (Parser)Preconditions.checkNotNull(profileParserFactory.createProfileParser());
        this.profileWriter = (ProfileWriter)Preconditions.checkNotNull((Object)profileWriter);
        this.profileProcessor = (ProfileProcessor)Preconditions.checkNotNull((Object)profileProcessor);
        this.tagsProviders = (List)Preconditions.checkNotNull(tagsProviders);
        this.saveProfileNormalizer = Objects.requireNonNull(saveProfileNormalizer);
    }

    public PipeData handle(CommandLineProfileTemplate profileTemplate, PipeData input) {
        Objects.requireNonNull(profileTemplate);
        OptionSet options = input.require(Topics.OPTION_SET);
        if (options.has(CRX2OakOption.SAVE_PROFILE.option)) {
            LOGGER.debug("The save option was given, the application will save the merged profile and abort the migration.");
            this.finalizeAndSaveProfile(profileTemplate, input);
            return Pipeline.streamClosed();
        }
        LOGGER.debug("The merged profile will be now loaded into CRX2Oak runtime state.");
        return this.useMergedProfileTemplate(profileTemplate, input);
    }

    private void finalizeAndSaveProfile(CommandLineProfileTemplate profileTemplate, PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        List<String> profilesToWrite = CliUtils.getOptionValuesAsStrings(CRX2OakOption.SAVE_PROFILE.option, options);
        Map<String, String> tags = this.redefineAllTags(profileTemplate, input);
        CommandLineProfileTemplate finalProfileTemplate = this.rebuildProfileTemplate(profileTemplate, tags);
        this.saveMergedProfileTemplate(profilesToWrite, this.saveProfileNormalizer.normalize(finalProfileTemplate));
    }

    private PipeData useMergedProfileTemplate(CommandLineProfileTemplate mergedProfile, PipeData input) {
        LOGGER.debug("Evaluating run-time tags for the merged profile.");
        PipeData partialOutput = this.applyCmdLineFromProfileToRuntimeState(mergedProfile, input);
        Map<String, String> allTags = this.redefineAllTags(mergedProfile, partialOutput);
        LOGGER.info("The following template tags has been defined: {}", allTags);
        CommandLineProfileTemplate profileTemplate = this.rebuildProfileTemplate(mergedProfile, allTags);
        return this.useProfileInRuntimeState(profileTemplate, partialOutput);
    }

    private Map<String, String> redefineAllTags(CommandLineProfileTemplate baseProfile, PipeData currentInput) {
        Map<String, String> runtimeTags = this.getRuntimeTags(currentInput);
        Map<String, String> profileTags = baseProfile.getRawProfileTemplate().getTagsWithValues();
        return this.mergeTags(profileTags, runtimeTags);
    }

    private Map<String, String> getRuntimeTags(PipeData input) {
        HashMap<String, String> tagsWithValuesMap = new HashMap<String, String>();
        for (TagsProvider provider : this.tagsProviders) {
            Map<String, String> tagsDefinitions = provider.provideTags(input);
            LOGGER.debug("The following template tags were provided: {} by {}.", tagsDefinitions, (Object)provider.getClass().getName());
            tagsWithValuesMap.putAll(tagsDefinitions);
        }
        return tagsWithValuesMap;
    }

    private PipeData applyCmdLineFromProfileToRuntimeState(CommandLineProfileTemplate mergedProfile, PipeData input) {
        CommandLineProfile commandLineProfile = this.convertIntoProfile(mergedProfile);
        LOGGER.info("Applying partly the command line (before loading a profile): {}", Arrays.asList((Object[])input.require(Topics.CMD_LINE_ARGS)));
        return PipeData.use(input).put(Topics.OPTION_SET, commandLineProfile.getCommandLine()).put(Topics.CMD_LINE_ARGS, commandLineProfile.getRawProfile().getCommandLineOptionsAndArguments().toArray(new String[0])).toPipe();
    }

    private PipeData useProfileInRuntimeState(CommandLineProfileTemplate profileTemplate, PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        Collection<String> unresolvedMandatoryTagNames = this.checkForMandatoryTags(options, profileTemplate);
        return unresolvedMandatoryTagNames.isEmpty() ? this.applyProfileToRuntimeState(profileTemplate, input) : this.returnUnresolvedTagsState(unresolvedMandatoryTagNames);
    }

    private PipeData applyProfileToRuntimeState(CommandLineProfileTemplate mergedProfile, PipeData state) {
        LOGGER.debug("Applying template tags for the merged profile template.");
        CommandLineProfile commandLineProfile = this.convertIntoProfile(mergedProfile);
        RawProfile rawProfile = commandLineProfile.getRawProfile();
        LOGGER.debug("The profile template was converted into a profile without template tags. Applying it to runtime state.");
        List<String> commandLineOptionsAndArguments = rawProfile.getCommandLineOptionsAndArguments();
        Collection<OsgiConfiguration> osgiConfigs = rawProfile.getOsgiConfigurations();
        PipeData output = PipeData.put(Topics.OPTION_SET, commandLineProfile.getCommandLine()).put(Topics.INSTALLABLE_OSGI_CONFIGS, osgiConfigs).put(Topics.CMD_LINE_ARGS, commandLineOptionsAndArguments.toArray(new String[0])).toPipe();
        LOGGER.debug("The following OSGi configurations will be installed from merged profile: {}", osgiConfigs);
        LOGGER.info("The command line (after loading a profile): {}", commandLineOptionsAndArguments);
        return output;
    }

    private Map<String, String> mergeTags(Map<String, String> profileTags, Map<String, String> runtimeTags) {
        HashMap<String, String> mergeResult = new HashMap<String, String>(profileTags);
        mergeResult.putAll(runtimeTags);
        return ImmutableMap.copyOf(mergeResult);
    }

    private CommandLineProfileTemplate rebuildProfileTemplate(CommandLineProfileTemplate mergedProfile, Map<String, String> tagsWithValuesMap) {
        return new CommandLineProfileTemplate(new RawProfileTemplate(mergedProfile.getRawProfileTemplate().getTemplatedCommandLineOptionsAndArguments(), mergedProfile.getRawProfileTemplate().getOsgiConfigurationsTemplates(), tagsWithValuesMap), mergedProfile.getEvaluatedCommandLine());
    }

    private PipeData returnUnresolvedTagsState(Collection<String> unresolvedMandatoryTagNames) {
        LOGGER.error("Tags: {} are required but their values were not resolved or not passed at command line.\n\nThis might indicate:\n\n1) Some dynamic tags weren't determined correctly (please check all WARN/ERROR log entries)\n2) Your custom profile is incorrect (i.e. tag name typos, missing tag definitions)\n3) The user should define the tag value at command line manually as profile doesn't specify the default value\n\nThe final profile is invalid (incomplete) hence the migration has been aborted.", unresolvedMandatoryTagNames);
        return Pipeline.streamClosed();
    }

    private Collection<String> checkForMandatoryTags(OptionSet options, CommandLineProfileTemplate profileTemplate) {
        Collection<String> mandatoryTags = this.getMandatoryTags(options);
        LOGGER.debug("Checking for mandatory tags: {}", mandatoryTags);
        Set<String> currentTags = profileTemplate.getRawProfileTemplate().getTagsWithValues().keySet();
        return this.getUnresolvedMandatoryTagNames(currentTags, mandatoryTags);
    }

    private Collection<String> getUnresolvedMandatoryTagNames(Set<String> currentTags, Collection<String> mandatoryTags) {
        HashSet<String> unresolvedTags = new HashSet<String>(mandatoryTags);
        unresolvedTags.removeAll(currentTags);
        return unresolvedTags;
    }

    private Collection<String> getMandatoryTags(OptionSet parsedOptions) {
        return new HashSet<String>(CliUtils.getOptionValuesAsStrings(CRX2OakOption.REQUIRE_TAG.option, parsedOptions));
    }

    private CommandLineProfile convertIntoProfile(CommandLineProfileTemplate mergedProfile) {
        RawProfile rawProfile = (RawProfile)Preconditions.checkNotNull((Object)this.profileProcessor.evaluate(mergedProfile));
        return (CommandLineProfile)Preconditions.checkNotNull((Object)this.profileParser.parse(rawProfile));
    }

    private void saveMergedProfileTemplate(List<String> profilesToWrite, CommandLineProfileTemplate mergedProfile) {
        for (String profileLocation : profilesToWrite) {
            LOGGER.info("Writing migration profile: {}", (Object)profileLocation);
            this.profileWriter.write(mergedProfile.getRawProfileTemplate(), profileLocation);
        }
    }
}

