/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile;

import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

final class ProfileLoadResult {
    private static final Iterable<CommandLineProfileTemplate> EMPTY_SET = Collections.emptySet();
    private static final Iterable<String> EMPTY_PROFILES_NOT_LOADED = Collections.emptySet();
    @Nonnull
    private final Iterable<CommandLineProfileTemplate> loadedProfiles;
    @Nonnull
    private final Iterable<String> profilesNotLoaded;

    static ProfileLoadResult success(@Nonnull Iterable<CommandLineProfileTemplate> loadedProfiles) {
        return new ProfileLoadResult(loadedProfiles, EMPTY_PROFILES_NOT_LOADED);
    }

    static ProfileLoadResult mixed(@Nonnull Iterable<CommandLineProfileTemplate> loadedProfiles, @Nonnull Iterable<String> profilesNotLoaded) {
        return new ProfileLoadResult(loadedProfiles, profilesNotLoaded);
    }

    static ProfileLoadResult error(@Nonnull Iterable<String> profilesNotLoaded) {
        return new ProfileLoadResult(EMPTY_SET, profilesNotLoaded);
    }

    static ProfileLoadResult successBlankLoad() {
        return new ProfileLoadResult(EMPTY_SET, EMPTY_PROFILES_NOT_LOADED);
    }

    private ProfileLoadResult(@Nonnull Iterable<CommandLineProfileTemplate> loadedProfiles, @Nonnull Iterable<String> profilesNotLoaded) {
        this.loadedProfiles = Objects.requireNonNull(loadedProfiles);
        this.profilesNotLoaded = Objects.requireNonNull(profilesNotLoaded);
    }

    @Nonnull
    public Iterable<CommandLineProfileTemplate> getLoadedProfiles() {
        return this.loadedProfiles;
    }

    @Nonnull
    public Iterable<String> getProfilesNotLoaded() {
        return this.profilesNotLoaded;
    }
}

