/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.profile.ProfileLoadResult;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.parse.Parser;
import com.adobe.granite.crx2oak.profile.parse.ProfileParserFactory;
import com.adobe.granite.crx2oak.profile.read.ProfileReader;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileLoader.class);
    public static final String DEFAULT_PROFILE_NAME = "segment-fds";
    private Parser<RawProfileTemplate, CommandLineProfileTemplate> profileTemplateParser;
    private final ProfileReader profileReader;
    private final ProfileReader embeddedProfileReader;

    public ProfileLoader(@Nonnull ProfileReader profileReader, @Nonnull ProfileParserFactory profileParserFactory, @Nonnull ProfileReader embeddedProfileReader) {
        this.profileReader = Objects.requireNonNull(profileReader);
        this.embeddedProfileReader = Objects.requireNonNull(embeddedProfileReader);
        this.profileTemplateParser = Objects.requireNonNull(profileParserFactory.createProfileTemplateParser());
    }

    public ProfileLoadResult load(PipeData input) {
        String[] cmdLineArgs = input.require(Topics.CMD_LINE_ARGS);
        OptionSet options = input.require(Topics.OPTION_SET);
        RunMode runMode = (RunMode)((Object)input.get(Topics.RUN_MODE).or((Object)RunMode.STANDALONE));
        return this.loadProfiles(cmdLineArgs, options, runMode);
    }

    private ProfileLoadResult loadProfiles(String[] cmdLineArgs, OptionSet options, RunMode runMode) {
        ProfileLoadResult partialResult = this.loadDefaultOrCustomProfiles(options, runMode);
        return this.insertProfileReflectingCurrentCli(cmdLineArgs, options, partialResult);
    }

    private ProfileLoadResult loadDefaultOrCustomProfiles(OptionSet parsedOptions, RunMode runMode) {
        return parsedOptions.has(CRX2OakOption.LOAD_PROFILE.option) ? this.loadProfilesFromCommandLine(parsedOptions) : this.getDefaultProfiles(runMode);
    }

    private ProfileLoadResult insertProfileReflectingCurrentCli(String[] commandLineArguments, OptionSet parsedOptions, ProfileLoadResult resultToMerge) {
        Iterable<CommandLineProfileTemplate> cmdLineProfile = this.createProfileFromCmdLine(commandLineArguments, parsedOptions);
        return ProfileLoadResult.mixed(Iterables.concat(cmdLineProfile, resultToMerge.getLoadedProfiles()), resultToMerge.getProfilesNotLoaded());
    }

    private Iterable<CommandLineProfileTemplate> createProfileFromCmdLine(String[] commandLineArguments, OptionSet parsedOptions) {
        return Collections.singleton(new CommandLineProfileTemplate(new RawProfileTemplate(Arrays.asList(commandLineArguments), Collections.emptySet(), Collections.emptyMap()), parsedOptions));
    }

    private ProfileLoadResult getDefaultProfiles(RunMode runMode) {
        return runMode == RunMode.QUICKSTART_EXTENSION ? this.loadDefaultProfile() : ProfileLoadResult.successBlankLoad();
    }

    private ProfileLoadResult loadDefaultProfile() {
        Optional<RawProfileTemplate> optionalDefaultProfile = this.embeddedProfileReader.read(DEFAULT_PROFILE_NAME);
        return optionalDefaultProfile.isPresent() ? ProfileLoadResult.success(Collections.singleton(this.profileTemplateParser.parse((RawProfileTemplate)optionalDefaultProfile.get()))) : this.getDefaultProfileLoadErrorResult();
    }

    private ProfileLoadResult getDefaultProfileLoadErrorResult() {
        LOGGER.error("The default embedded profile: %s is not present. The application package seems to be incomplete.", (Object)DEFAULT_PROFILE_NAME);
        return ProfileLoadResult.error(Collections.singleton(DEFAULT_PROFILE_NAME));
    }

    private ProfileLoadResult loadProfilesFromCommandLine(OptionSet parsedOptions) {
        List<String> profileLocations = this.getProfileLocationsToReadFromCommandLine(parsedOptions);
        LOGGER.debug("Going to load the following profiles based on command line request: {}", profileLocations);
        Map<String, CommandLineProfileTemplate> foundProfiles = this.loadProfilesMappedToLocation(profileLocations);
        Set<String> profilesNotFound = this.getProfileLocationsNotLoaded(profileLocations, foundProfiles);
        return profilesNotFound.isEmpty() ? ProfileLoadResult.success(this.getProfileTemplatesSortedByUserPreference(profileLocations, foundProfiles)) : ProfileLoadResult.mixed(foundProfiles.values(), profilesNotFound);
    }

    private Collection<CommandLineProfileTemplate> getProfileTemplatesSortedByUserPreference(List<String> profileLocations, Map<String, CommandLineProfileTemplate> foundProfiles) {
        ArrayList<CommandLineProfileTemplate> commandLineProfileTemplates = new ArrayList<CommandLineProfileTemplate>();
        for (String profileLocation : profileLocations) {
            commandLineProfileTemplates.add(Objects.requireNonNull(foundProfiles.get(profileLocation)));
        }
        return commandLineProfileTemplates;
    }

    private Set<String> getProfileLocationsNotLoaded(List<String> profileLocations, Map<String, CommandLineProfileTemplate> foundProfiles) {
        HashSet<String> profilesNotFound = new HashSet<String>(profileLocations);
        profilesNotFound.removeAll(foundProfiles.keySet());
        return profilesNotFound;
    }

    private Map<String, CommandLineProfileTemplate> loadProfilesMappedToLocation(List<String> profileLocations) {
        HashMap<String, CommandLineProfileTemplate> foundProfiles = new HashMap<String, CommandLineProfileTemplate>();
        for (String profileLocation : profileLocations) {
            foundProfiles.putAll(this.loadProfileMappedToName(profileLocation));
        }
        return foundProfiles;
    }

    private Map<String, CommandLineProfileTemplate> loadProfileMappedToName(String profileLocation) {
        LOGGER.info("Reading migration profile: {}", (Object)profileLocation);
        Optional<CommandLineProfileTemplate> commandLineProfileTemplate = this.getProfileContents(profileLocation);
        return commandLineProfileTemplate.isPresent() ? Collections.singletonMap(profileLocation, commandLineProfileTemplate.get()) : this.returnProfileNotFoundMap(profileLocation);
    }

    private Map<String, CommandLineProfileTemplate> returnProfileNotFoundMap(String profileLocation) {
        LOGGER.error("The profile: '{}' was not found neither in application nor in filesystem.", (Object)profileLocation);
        return Collections.emptyMap();
    }

    private Optional<CommandLineProfileTemplate> getProfileContents(String profileLocation) {
        LOGGER.debug("Trying to find a built-in profile: {} in application itself.", (Object)profileLocation);
        Optional<RawProfileTemplate> optionalRawProfileTemplate = this.embeddedProfileReader.read(profileLocation);
        if (!optionalRawProfileTemplate.isPresent()) {
            LOGGER.debug("The built-in profile not present. Trying to find on filesystem: {}", (Object)profileLocation);
            optionalRawProfileTemplate = this.profileReader.read(profileLocation);
        } else {
            LOGGER.debug("Found a built-in profile: {}", (Object)profileLocation);
        }
        return optionalRawProfileTemplate.isPresent() ? Optional.of((Object)this.profileTemplateParser.parse((RawProfileTemplate)optionalRawProfileTemplate.get())) : Optional.absent();
    }

    private List<String> getProfileLocationsToReadFromCommandLine(OptionSet parsedOptions) {
        return CliUtils.getOptionValuesAsStrings(CRX2OakOption.LOAD_PROFILE.option, parsedOptions);
    }
}

