/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile;

import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.profile.ProfileChainMerger;
import com.adobe.granite.crx2oak.profile.ProfileHandler;
import com.adobe.granite.crx2oak.profile.ProfileLoadResult;
import com.adobe.granite.crx2oak.profile.ProfileLoader;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMainProcessor
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileMainProcessor.class);
    private final ProfileLoader profileLoader;
    private final ProfileChainMerger profileChainMerger;
    private final ProfileHandler profileHandler;

    public ProfileMainProcessor(ProfileLoader profileLoader, ProfileChainMerger profileChainMerger, ProfileHandler profileHandler) {
        this.profileLoader = (ProfileLoader)Preconditions.checkNotNull((Object)profileLoader);
        this.profileChainMerger = (ProfileChainMerger)Preconditions.checkNotNull((Object)profileChainMerger);
        this.profileHandler = (ProfileHandler)Preconditions.checkNotNull((Object)profileHandler);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        LOGGER.debug("Loading profiles");
        ProfileLoadResult loadResult = this.profileLoader.load(input);
        return Iterables.isEmpty(loadResult.getProfilesNotLoaded()) ? this.handleLoadedProfiles(input, loadResult) : this.closeStreamWithProfilesNotLoadedWarning(input, loadResult);
    }

    private PipeData closeStreamWithProfilesNotLoadedWarning(PipeData input, ProfileLoadResult loadResult) {
        return this.closedStreamWithWarning(input, String.format("The following profiles you specified cannot be found: %s", loadResult.getProfilesNotLoaded()));
    }

    private PipeData closedStreamWithWarning(PipeData input, String warning) {
        return Pipeline.streamClosed(PipeData.join(input, Topics.WARNINGS, warning).toPipe());
    }

    private PipeData handleLoadedProfiles(PipeData input, ProfileLoadResult loadResult) {
        LOGGER.debug("Merging profiles (if applicable)");
        Optional<CommandLineProfileTemplate> profile = this.profileChainMerger.merge(loadResult.getLoadedProfiles());
        return profile.isPresent() ? this.handleExistingProfile(input, (CommandLineProfileTemplate)profile.get()) : PipeData.EMPTY;
    }

    private PipeData handleExistingProfile(PipeData input, CommandLineProfileTemplate profile) {
        LOGGER.debug("The merged profile is present. Handling the unified profile.");
        return this.profileHandler.handle(profile, input);
    }
}

