/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.merge;

import com.adobe.granite.crx2oak.cli.transformer.CommandLineCaptureEventTransformer;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.profile.merge.ProfileCommandLineEventTransformer;
import com.adobe.granite.crx2oak.profile.merge.ProfileMerger;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditiveProfileMerger
implements ProfileMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditiveProfileMerger.class);
    private final CommandLineTransformerEngine commandLineTransformerEngine;

    public AdditiveProfileMerger(CommandLineTransformerEngine commandLineTransformerEngine) {
        this.commandLineTransformerEngine = (CommandLineTransformerEngine)Preconditions.checkNotNull((Object)commandLineTransformerEngine);
    }

    @Override
    public RawProfileTemplate merge(CommandLineProfileTemplate initialProfile, CommandLineProfileTemplate mergingProfile) {
        LOGGER.trace("The following profiles will be merged: {} and {}.", (Object)initialProfile, (Object)mergingProfile);
        RawProfileTemplate rawProfileTemplate = new RawProfileTemplate(this.mergeCommandLines(initialProfile, mergingProfile), this.mergeOsgiConfigurations(initialProfile.getRawProfileTemplate().getOsgiConfigurationsTemplates(), mergingProfile.getRawProfileTemplate().getOsgiConfigurationsTemplates()), this.mergeProfilePlaceholders(initialProfile.getRawProfileTemplate().getTagsWithValues(), mergingProfile.getRawProfileTemplate().getTagsWithValues()));
        LOGGER.debug("The following profiles: {} and {} were merged into {}", new Object[]{initialProfile, mergingProfile, rawProfileTemplate});
        return rawProfileTemplate;
    }

    private Map<String, String> mergeProfilePlaceholders(Map<String, String> initialProfilePlaceholders, Map<String, String> mergingProfilePlaceholders) {
        HashMap<String, String> mergedPlaceholders = new HashMap<String, String>(initialProfilePlaceholders);
        for (Map.Entry<String, String> entry : mergingProfilePlaceholders.entrySet()) {
            mergedPlaceholders.putAll(this.getEntryAsMapIfNotInExistingMap(initialProfilePlaceholders, entry));
        }
        return mergedPlaceholders;
    }

    private Map<String, String> getEntryAsMapIfNotInExistingMap(Map<String, String> existingMap, Map.Entry<String, String> entry) {
        return !existingMap.containsKey(entry.getKey()) ? Collections.singletonMap(entry.getKey(), entry.getValue()) : Collections.emptyMap();
    }

    private Collection<OsgiConfiguration> mergeOsgiConfigurations(Collection<OsgiConfiguration> initialProfileOsgiConfigurations, Collection<OsgiConfiguration> mergingProfileOsgiConfigurations) {
        HashSet<OsgiConfiguration> mergedOsgiConfigurations = new HashSet<OsgiConfiguration>(initialProfileOsgiConfigurations);
        mergedOsgiConfigurations.addAll(this.getNotExistingOsgiConfigurations(mergingProfileOsgiConfigurations, this.getFilenameToOsgiConfigurationMap(initialProfileOsgiConfigurations)));
        return mergedOsgiConfigurations;
    }

    private Map<String, OsgiConfiguration> getFilenameToOsgiConfigurationMap(Collection<OsgiConfiguration> mergedOsgiConfigurationTemplates) {
        HashMap<String, OsgiConfiguration> filenameToOsgiConfigurationTemplateMap = new HashMap<String, OsgiConfiguration>();
        for (OsgiConfiguration osgiConfigurationTemplate : mergedOsgiConfigurationTemplates) {
            filenameToOsgiConfigurationTemplateMap.put(osgiConfigurationTemplate.getDestinationFilename(), osgiConfigurationTemplate);
        }
        return filenameToOsgiConfigurationTemplateMap;
    }

    private List<String> mergeCommandLines(CommandLineProfileTemplate initialProfile, CommandLineProfileTemplate mergingProfile) {
        CommandLineCaptureEventTransformer captureTransformer = new CommandLineCaptureEventTransformer();
        this.commandLineTransformerEngine.transformIntoCommandLine(mergingProfile.getEvaluatedCommandLine(), captureTransformer);
        ProfileCommandLineEventTransformer profileCommandLineEventTransformer = new ProfileCommandLineEventTransformer(captureTransformer.getCapturedOptions(), captureTransformer.getCapturedArguments());
        return Arrays.asList(this.commandLineTransformerEngine.transformIntoCommandLine(initialProfile.getEvaluatedCommandLine(), profileCommandLineEventTransformer));
    }

    private Collection<OsgiConfiguration> getNotExistingOsgiConfigurations(Collection<OsgiConfiguration> osgiConfigurationAddCandidates, Map<String, OsgiConfiguration> existingTemplatesByFilenameMap) {
        HashSet<OsgiConfiguration> osgiConfigurationsToBeAdded = new HashSet<OsgiConfiguration>();
        for (OsgiConfiguration osgiConfiguration : osgiConfigurationAddCandidates) {
            osgiConfigurationsToBeAdded.addAll(this.getOsgiConfigurationAsCollectionIfFilenameNotMapped(existingTemplatesByFilenameMap, osgiConfiguration));
        }
        return osgiConfigurationsToBeAdded;
    }

    private Collection<OsgiConfiguration> getOsgiConfigurationAsCollectionIfFilenameNotMapped(Map<String, OsgiConfiguration> filenameToOsgiConfigurationMapping, OsgiConfiguration osgiConfiguration) {
        return !filenameToOsgiConfigurationMapping.containsKey(osgiConfiguration.getDestinationFilename()) ? Collections.singleton(osgiConfiguration) : Collections.emptySet();
    }
}

