/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.merge;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.TransparentCommandLineEventTransformer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;

class ProfileCommandLineEventTransformer
extends TransparentCommandLineEventTransformer {
    private final Collection<CmdLineOption> optionsToBeAdded;
    private Collection<String> defaultArguments;
    private static final ImmutableList<String> PROFILE_OPTIONS = ImmutableList.of((Object)CRX2OakOption.LOAD_PROFILE.option, (Object)CRX2OakOption.SAVE_PROFILE.option);
    private static final Set<CmdLineOption> EMPTY_COMMAND_LINE_OPTIONS = Collections.emptySet();

    ProfileCommandLineEventTransformer(@Nonnull Collection<CmdLineOption> optionsToBeAdded, @Nonnull Collection<String> defaultArguments) {
        this.optionsToBeAdded = (Collection)Preconditions.checkNotNull(optionsToBeAdded);
        this.defaultArguments = (Collection)Preconditions.checkNotNull(defaultArguments);
    }

    @Override
    @Nonnull
    public Collection<CmdLineOption> transformOption(@Nonnull CmdLineOption option) {
        return this.passAllTheOptionsExceptOfProfileRelatedOnes(option);
    }

    private Collection<CmdLineOption> passAllTheOptionsExceptOfProfileRelatedOnes(CmdLineOption option) {
        return this.isNotAProfileOption(option) ? super.transformOption(option) : EMPTY_COMMAND_LINE_OPTIONS;
    }

    private boolean isNotAProfileOption(CmdLineOption option) {
        return !PROFILE_OPTIONS.contains((Object)option.getOption());
    }

    @Override
    @Nonnull
    public Collection<CmdLineOption> getAdditionalOptions() {
        return this.optionsToBeAdded;
    }

    @Override
    @Nonnull
    public Collection<String> transformArguments(@Nonnull OptionSet optionSet) {
        Collection<String> existingArguments = super.transformArguments(optionSet);
        return existingArguments.isEmpty() ? this.defaultArguments : existingArguments;
    }
}

