/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.model.osgi;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class OsgiConfiguration {
    @Nonnull
    private final String destinationFilename;
    @Nonnull
    private final String osgiConfiguration;

    public OsgiConfiguration(@Nonnull String destinationFilename, @Nonnull String osgiConfiguration) {
        this.destinationFilename = (String)Preconditions.checkNotNull((Object)destinationFilename);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)destinationFilename), (Object)"Destination filename cannot be empty");
        this.osgiConfiguration = (String)Preconditions.checkNotNull((Object)osgiConfiguration);
    }

    @Nonnull
    public String getDestinationFilename() {
        return this.destinationFilename;
    }

    @Nonnull
    public String getOsgiConfiguration() {
        return this.osgiConfiguration;
    }

    public String toString() {
        return "OsgiConfiguration{destinationFilename='" + this.destinationFilename + '\'' + ", osgiConfiguration='" + this.osgiConfiguration + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OsgiConfiguration that = (OsgiConfiguration)o;
        return this.destinationFilename.equals(that.destinationFilename) && this.osgiConfiguration.equals(that.osgiConfiguration);
    }

    public int hashCode() {
        int result = this.destinationFilename.hashCode();
        result = 31 * result + this.osgiConfiguration.hashCode();
        return result;
    }
}

