/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.normalize;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.cli.transformer.TransparentCommandLineEventTransformer;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.normalize.ProfileNormalizer;
import com.adobe.granite.crx2oak.profile.parse.Parser;
import com.adobe.granite.crx2oak.profile.parse.ProfileParserFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public class TagsDefinitionCleaner
extends TransparentCommandLineEventTransformer
implements ProfileNormalizer {
    private final Parser<RawProfileTemplate, CommandLineProfileTemplate> profileTemplateParser;
    private final CommandLineTransformerEngine transformerEngine;

    public TagsDefinitionCleaner(CommandLineTransformerEngine transformerEngine, ProfileParserFactory parserFactory) {
        this.transformerEngine = transformerEngine;
        this.profileTemplateParser = parserFactory.createProfileTemplateParser();
    }

    @Override
    @Nonnull
    public Collection<CmdLineOption> transformOption(@Nonnull CmdLineOption option) {
        return option.getOption().equals(CRX2OakOption.TAG_NAME.option) || option.getOption().equals(CRX2OakOption.TAG_VALUE.option) || option.getOption().equals(CRX2OakOption.TAG_DEFINITION.option) ? Collections.emptySet() : super.transformOption(option);
    }

    @Override
    @Nonnull
    public CommandLineProfileTemplate normalize(@Nonnull CommandLineProfileTemplate input) {
        String[] str = this.transformerEngine.transformIntoCommandLine(input.getEvaluatedCommandLine(), this);
        return this.profileTemplateParser.parse(new RawProfileTemplate(Arrays.asList(str), input.getRawProfileTemplate().getOsgiConfigurationsTemplates(), input.getRawProfileTemplate().getTagsWithValues()));
    }
}

