/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.parse;

import com.adobe.granite.crx2oak.profile.model.profile.CommandLineProfile;
import com.adobe.granite.crx2oak.profile.model.profile.RawProfile;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.parse.Parser;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class ProfileParserFactory {
    private final OptionParser optionParser;

    public ProfileParserFactory(@Nonnull OptionParser optionParser) {
        this.optionParser = (OptionParser)Preconditions.checkNotNull((Object)optionParser);
    }

    private OptionSet getOptionSet(List<String> commandLineOptionsAndArguments) {
        return this.optionParser.parse(commandLineOptionsAndArguments.toArray(new String[0]));
    }

    public Parser<RawProfileTemplate, CommandLineProfileTemplate> createProfileTemplateParser() {
        return new ProfileTemplateParser();
    }

    public Parser<RawProfile, CommandLineProfile> createProfileParser() {
        return new ProfileParser();
    }

    private class ProfileParser
    implements Parser<RawProfile, CommandLineProfile> {
        private ProfileParser() {
        }

        @Override
        public CommandLineProfile parse(RawProfile rawProfile) {
            OptionSet optionSet = ProfileParserFactory.this.getOptionSet(rawProfile.getCommandLineOptionsAndArguments());
            return new CommandLineProfile(rawProfile, optionSet);
        }
    }

    private class ProfileTemplateParser
    implements Parser<RawProfileTemplate, CommandLineProfileTemplate> {
        private ProfileTemplateParser() {
        }

        @Override
        public CommandLineProfileTemplate parse(RawProfileTemplate rawProfileTemplate) {
            List<String> commandLineOptionsAndArguments = rawProfileTemplate.getTemplatedCommandLineOptionsAndArguments();
            OptionSet op = ProfileParserFactory.this.getOptionSet(commandLineOptionsAndArguments);
            return new CommandLineProfileTemplate(rawProfileTemplate, op);
        }
    }
}

