/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.process;

import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.TransparentCommandLineEventTransformer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.apache.commons.lang3.text.StrSubstitutor;

public class CommandLinePlaceholderApplier
extends TransparentCommandLineEventTransformer {
    private final StrSubstitutor strSubstitutor;

    public CommandLinePlaceholderApplier(@Nonnull StrSubstitutor strSubstitutor) {
        this.strSubstitutor = (StrSubstitutor)Preconditions.checkNotNull((Object)strSubstitutor);
    }

    @Override
    @Nonnull
    public Collection<CmdLineOption> transformOption(@Nonnull CmdLineOption option) {
        return option.hasArgument() ? Collections.singletonList(this.getImmutableCommandLineOptionWithAppliedPlaceholders(option)) : super.transformOption(option);
    }

    private CmdLineOption getImmutableCommandLineOptionWithAppliedPlaceholders(CmdLineOption o) {
        return CmdLineOption.withArgument(o.getOption(), this.strSubstitutor.replace(o.getArgument()));
    }

    @Override
    @Nonnull
    public Collection<String> transformArguments(@Nonnull OptionSet optionSet) {
        return this.getFinalSubstitutedArgs(super.transformArguments(optionSet));
    }

    private Collection<String> getFinalSubstitutedArgs(Collection<String> args) {
        ArrayList<String> finalArgs = new ArrayList<String>();
        for (String arg : args) {
            finalArgs.add(this.strSubstitutor.replace(arg));
        }
        return finalArgs;
    }
}

