/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.process;

import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.profile.RawProfile;
import com.adobe.granite.crx2oak.profile.model.template.CommandLineProfileTemplate;
import com.adobe.granite.crx2oak.profile.process.CommandLinePlaceholderApplier;
import com.adobe.granite.crx2oak.profile.process.ProfileProcessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import org.apache.commons.lang3.text.StrSubstitutor;

public class TagProfileProcessor
implements ProfileProcessor {
    private static final String MUSTACHE_TAG_PREFIX = "{{";
    private static final String MUSTACHE_TAG_SUFFIX = "}}";
    private final CommandLineTransformerEngine commandLineTransformerEngine;

    public static String formatAsTemplateTag(String tagName) {
        Preconditions.checkNotNull((Object)tagName);
        return MUSTACHE_TAG_PREFIX + tagName + MUSTACHE_TAG_SUFFIX;
    }

    public static Iterable<String> formatAsTemplateTags(Iterable<String> tagNames) {
        Preconditions.checkNotNull(tagNames);
        return Iterables.transform(tagNames, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String templateTagName) {
                return TagProfileProcessor.formatAsTemplateTag(templateTagName);
            }
        });
    }

    public TagProfileProcessor(CommandLineTransformerEngine commandLineTransformerEngine) {
        this.commandLineTransformerEngine = commandLineTransformerEngine;
    }

    @Override
    @Nonnull
    public RawProfile evaluate(@Nonnull CommandLineProfileTemplate commandLineProfileTemplate) {
        StrSubstitutor substitutor = this.getMustacheSubstitutor(commandLineProfileTemplate);
        Collection<OsgiConfiguration> finalOsgiConfigurations = this.applyPlaceholdersForOsgiConfigurations(substitutor, commandLineProfileTemplate.getRawProfileTemplate().getOsgiConfigurationsTemplates());
        List<String> finalCommandLine = this.applyPlaceholdersForCommandLine(commandLineProfileTemplate.getEvaluatedCommandLine(), substitutor);
        return new RawProfile(finalCommandLine, finalOsgiConfigurations);
    }

    private List<String> applyPlaceholdersForCommandLine(OptionSet evaluatedCommandLine, StrSubstitutor substitutor) {
        CommandLinePlaceholderApplier transformer = new CommandLinePlaceholderApplier(substitutor);
        return Arrays.asList(this.commandLineTransformerEngine.transformIntoCommandLine(evaluatedCommandLine, transformer));
    }

    private Collection<OsgiConfiguration> applyPlaceholdersForOsgiConfigurations(StrSubstitutor substitutor, Collection<OsgiConfiguration> osgiConfigurations) {
        ArrayList<OsgiConfiguration> osgiConfigurationsWithoutPlaceholders = new ArrayList<OsgiConfiguration>();
        for (OsgiConfiguration osgiConfiguration : osgiConfigurations) {
            osgiConfigurationsWithoutPlaceholders.add(this.getOsgiConfigurationWithAppliedPlaceholders(substitutor, osgiConfiguration));
        }
        return osgiConfigurationsWithoutPlaceholders;
    }

    private OsgiConfiguration getOsgiConfigurationWithAppliedPlaceholders(StrSubstitutor substitutor, OsgiConfiguration osgiConfiguration) {
        return new OsgiConfiguration(osgiConfiguration.getDestinationFilename(), substitutor.replace(osgiConfiguration.getOsgiConfiguration()));
    }

    private StrSubstitutor getMustacheSubstitutor(@Nonnull CommandLineProfileTemplate commandLineProfileTemplate) {
        return new StrSubstitutor(commandLineProfileTemplate.getRawProfileTemplate().getTagsWithValues(), MUSTACHE_TAG_PREFIX, MUSTACHE_TAG_SUFFIX, '\u0000');
    }
}

