/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.read;

import com.adobe.granite.crx2oak.profile.ProfileStorageFormatConstants;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.read.MaterializedCommandLineReader;
import com.adobe.granite.crx2oak.profile.read.ProfileReadException;
import com.adobe.granite.crx2oak.profile.read.ProfileReader;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClasspathProfileReader
implements ProfileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathProfileReader.class);
    public static final String CLASSPATH_COMPONENT_SEPARATOR = "/";
    public static final String ONE_LEVEL_CLASSPATH_WILDCARD_PATTERN = "*";
    public static final String EMPTY_STRING = "";
    private final MaterializedCommandLineReader materializedCommandLineReader;

    public ClasspathProfileReader(@Nonnull MaterializedCommandLineReader materializedCommandLineReader) {
        this.materializedCommandLineReader = (MaterializedCommandLineReader)Preconditions.checkNotNull((Object)materializedCommandLineReader);
    }

    @Override
    public Optional<RawProfileTemplate> read(@Nonnull String profileLocation) throws ProfileReadException {
        try {
            return this.profileExists(profileLocation) ? Optional.of((Object)this.readExistingProfile(profileLocation)) : Optional.absent();
        }
        catch (IOException e) {
            LOGGER.error("Cannot check for classpath profile existence", (Throwable)e);
            throw new ProfileReadException(e);
        }
    }

    private RawProfileTemplate readExistingProfile(String profileLocation) throws IOException {
        String profileCommandLine = this.getProfileCommandLine(profileLocation);
        Collection<OsgiConfiguration> osgiConfigurations = this.getOsgiConfigurations(profileLocation);
        Map<String, String> tagsWithValues = this.getTagsDefinitions(profileLocation);
        return new RawProfileTemplate(this.materializedCommandLineReader.readMaterializedCommandLine(profileCommandLine), osgiConfigurations, tagsWithValues);
    }

    private Map<String, String> getTagsDefinitions(String profileLocation) throws IOException {
        Resource[] osgiConfigurationResources;
        HashMap<String, String> tagsDefinitions = new HashMap<String, String>();
        for (Resource tagDefinitionResource : osgiConfigurationResources = this.getProfileResourcesFor(profileLocation, (Optional<String>)Optional.of((Object)"tags"))) {
            tagsDefinitions.put(tagDefinitionResource.getFilename(), this.getResourceContent(tagDefinitionResource).trim());
        }
        return tagsDefinitions;
    }

    private Collection<OsgiConfiguration> getOsgiConfigurations(String profileLocation) throws IOException {
        Resource[] osgiConfigurationResources;
        ArrayList<OsgiConfiguration> osgiConfigurations = new ArrayList<OsgiConfiguration>();
        for (Resource osgiConfigurationResource : osgiConfigurationResources = this.getProfileResourcesFor(profileLocation, (Optional<String>)Optional.of((Object)"osgi-configs"))) {
            osgiConfigurations.add(new OsgiConfiguration(osgiConfigurationResource.getFilename(), this.getResourceContent(osgiConfigurationResource)));
        }
        return osgiConfigurations;
    }

    public boolean profileExists(String profileName) throws IOException {
        LOGGER.debug("Checking if profile: {} exists", (Object)profileName);
        for (Resource resource : this.getProfileResourcesFor(profileName)) {
            LOGGER.trace("Analyzing resource and looking for control file: {}", (Object)resource.getURL());
            if (!this.checkForProfileControlFile(resource)) continue;
            return true;
        }
        return false;
    }

    private String getProfileCommandLine(String profileName) throws IOException {
        for (Resource resource : this.getProfileResourcesFor(profileName)) {
            LOGGER.trace("Analyzing resource: {}", (Object)resource.getURL());
            if (!this.checkForProfileCommandLineFile(resource)) continue;
            return this.getResourceContent(resource);
        }
        return EMPTY_STRING;
    }

    private boolean checkForProfileCommandLineFile(Resource resource) throws IOException {
        return "cmdline".equals(resource.getFilename()) && resource.exists();
    }

    private boolean checkForProfileControlFile(Resource resource) throws IOException {
        return "profile".equals(resource.getFilename()) && resource.exists() && this.checkProfileControlFileContent(resource);
    }

    private boolean checkProfileControlFileContent(Resource resource) throws IOException {
        return "PR0F1L3".equals(this.getResourceContent(resource));
    }

    private String getResourceContent(Resource resource) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)resource.getInputStream(), (Writer)writer, (Charset)ProfileStorageFormatConstants.PROFILE_CHARSET);
        return writer.toString();
    }

    private Resource[] getProfileResourcesFor(String profileName) throws IOException {
        return this.getProfileResourcesFor(profileName, (Optional<String>)Optional.absent());
    }

    private Resource[] getProfileResourcesFor(String profileName, Optional<String> optionalComponentDirectory) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(cl);
        String optionalComponentPath = this.getRequiredComponentPathFromOptionalDirectory(optionalComponentDirectory);
        String locationPattern = "classpath*:/profiles/" + profileName.replace(CLASSPATH_COMPONENT_SEPARATOR, EMPTY_STRING) + optionalComponentPath + CLASSPATH_COMPONENT_SEPARATOR + ONE_LEVEL_CLASSPATH_WILDCARD_PATTERN;
        LOGGER.trace("Finding resources under {}", (Object)locationPattern);
        return resolver.getResources(locationPattern);
    }

    private String getRequiredComponentPathFromOptionalDirectory(Optional<String> optionalComponentDirectory) {
        return optionalComponentDirectory.isPresent() ? CLASSPATH_COMPONENT_SEPARATOR + (String)optionalComponentDirectory.get() : EMPTY_STRING;
    }
}

