/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.read;

import com.adobe.granite.crx2oak.profile.ProfileStorageFormatConstants;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.read.MaterializedCommandLineReader;
import com.adobe.granite.crx2oak.profile.read.ProfileReadException;
import com.adobe.granite.crx2oak.profile.read.ProfileReader;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemProfileReader
implements ProfileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemProfileReader.class);
    public static final File[] EMPTY_ARRAY_OF_FILES = new File[0];
    private final MaterializedCommandLineReader materializedCommandLineReader;

    public FilesystemProfileReader(MaterializedCommandLineReader materializedCommandLineReader) {
        this.materializedCommandLineReader = (MaterializedCommandLineReader)Preconditions.checkNotNull((Object)materializedCommandLineReader);
    }

    @Override
    public Optional<RawProfileTemplate> read(@Nonnull String profileLocation) throws ProfileReadException {
        LOGGER.debug("Reading a migration profile from filesystem using a path: {}", (Object)profileLocation);
        File rootProfileDirectory = new File(profileLocation);
        if (rootProfileDirectory.isDirectory() && rootProfileDirectory.exists()) {
            Collection<OsgiConfiguration> osgiConfigurations = this.readOsgiConfigurations(new File(rootProfileDirectory, "osgi-configs"));
            Map<String, String> tagsDefinitions = this.readTagsDefinitions(new File(rootProfileDirectory, "tags"));
            List<String> commandLineTemplate = this.readCommandLineTemplate(new File(rootProfileDirectory, "cmdline"));
            return Optional.of((Object)new RawProfileTemplate(commandLineTemplate, osgiConfigurations, tagsDefinitions));
        }
        LOGGER.debug("Cannot load profile: {}. It doesn't exist or is not a directory.", (Object)profileLocation);
        return Optional.absent();
    }

    private List<String> readCommandLineTemplate(File cmdLineFile) {
        LOGGER.debug("Reading an optional command line template file: {}", (Object)cmdLineFile);
        if (cmdLineFile.exists()) {
            return this.readAndTokenizeCommandLineFile(cmdLineFile);
        }
        LOGGER.debug("The command line option template does not exist: {}", (Object)cmdLineFile);
        return Collections.emptyList();
    }

    private List<String> readAndTokenizeCommandLineFile(File cmdLineFile) {
        if (cmdLineFile.canRead()) {
            return this.readAndTokenizeCommandLineFileUnverified(cmdLineFile);
        }
        LOGGER.error("The command line option template: {} is not readable. Aborting profile loading", (Object)cmdLineFile.getAbsolutePath());
        throw new ProfileReadException();
    }

    private List<String> readAndTokenizeCommandLineFileUnverified(File cmdLineFile) {
        try {
            return this.readAndTokenizeCommandLineFileUnchecked(cmdLineFile);
        }
        catch (IOException e) {
            LOGGER.error("Cannot read tag definition file or incorrect file encoding: {}. The profile template might be corrupted hence aborting loading.", (Object)cmdLineFile.getAbsolutePath());
            throw new ProfileReadException(e);
        }
    }

    private List<String> readAndTokenizeCommandLineFileUnchecked(File cmdLineFile) throws IOException {
        return this.materializedCommandLineReader.readMaterializedCommandLine(Files.toString((File)cmdLineFile, (Charset)ProfileStorageFormatConstants.PROFILE_CHARSET));
    }

    private Map<String, String> readTagsDefinitions(File file) {
        IOFileFilter filesOnlyFilter = FileFileFilter.FILE;
        return this.getTagsDefinitionsFromFiles(this.listFilesIfDirPresentOrReturnEmptyList(file, (FileFilter)filesOnlyFilter));
    }

    private File[] listFilesIfDirPresentOrReturnEmptyList(File dir, FileFilter filesOnlyFilter) {
        return dir.isDirectory() && dir.exists() ? dir.listFiles(filesOnlyFilter) : EMPTY_ARRAY_OF_FILES;
    }

    private Map<String, String> getTagsDefinitionsFromFiles(File[] tagDefinitionFiles) {
        HashMap<String, String> tagsWithValues = new HashMap<String, String>();
        for (File tagDefinitionFile : tagDefinitionFiles) {
            tagsWithValues.putAll(this.getTagFromFileAsMap(tagDefinitionFile));
        }
        return tagsWithValues;
    }

    private Map<String, String> getTagFromFileAsMap(File tagDefinitionFile) {
        LOGGER.trace("Analyzing tag definition: {}", (Object)tagDefinitionFile.getAbsolutePath());
        if (tagDefinitionFile.canRead()) {
            return this.readTagFromFile(tagDefinitionFile);
        }
        LOGGER.error("Cannot read tag definition file: {}. It is likely that the profile template might be incorrect hence aborting loading.", (Object)tagDefinitionFile.getAbsolutePath());
        throw new ProfileReadException();
    }

    private Map<String, String> readTagFromFile(File tagDefinitionFile) {
        LOGGER.debug("Reading a tag definition file: {}", (Object)tagDefinitionFile);
        try {
            return Collections.singletonMap(tagDefinitionFile.getName(), Files.toString((File)tagDefinitionFile, (Charset)ProfileStorageFormatConstants.PROFILE_CHARSET).trim());
        }
        catch (IOException e) {
            LOGGER.error("Cannot read tag definition file or incorrect file encoding: {}. The profile template might be corrupted hence aborting loading.", (Object)tagDefinitionFile.getAbsolutePath());
            throw new ProfileReadException(e);
        }
    }

    private Collection<OsgiConfiguration> readOsgiConfigurations(File file) {
        IOFileFilter filesOnlyFilter = FileFileFilter.FILE;
        return this.getOsgiConfigurationsFromFiles(this.listFilesIfDirPresentOrReturnEmptyList(file, (FileFilter)filesOnlyFilter));
    }

    private Collection<OsgiConfiguration> getOsgiConfigurationsFromFiles(File[] osgiConfigurationFiles) {
        ArrayList<OsgiConfiguration> osgiConfigurations = new ArrayList<OsgiConfiguration>();
        for (File osgiConfigurationFile : osgiConfigurationFiles) {
            osgiConfigurations.addAll(this.getOsgiConfigurationsFromFile(osgiConfigurationFile));
        }
        return osgiConfigurations;
    }

    private Collection<OsgiConfiguration> getOsgiConfigurationsFromFile(File osgiConfigurationFile) {
        LOGGER.trace("Analyzing OSGi configuration file: {}", (Object)osgiConfigurationFile.getAbsolutePath());
        if (osgiConfigurationFile.canRead()) {
            return this.readOsgiConfigurationFile(osgiConfigurationFile);
        }
        LOGGER.error("Cannot read OSGi configuration: {}. It will be skipped during profile loading", (Object)osgiConfigurationFile.getAbsolutePath());
        return Collections.emptyList();
    }

    private Collection<OsgiConfiguration> readOsgiConfigurationFile(File osgiConfigurationFile) {
        LOGGER.debug("Reading an OSGi configuration file: {}", (Object)osgiConfigurationFile);
        try {
            return Collections.singleton(new OsgiConfiguration(osgiConfigurationFile.getName(), Files.toString((File)osgiConfigurationFile, (Charset)ProfileStorageFormatConstants.PROFILE_CHARSET)));
        }
        catch (IOException e) {
            LOGGER.error("Cannot read OSGi configuration file or incorrect file encoding: {}", (Object)osgiConfigurationFile.getAbsolutePath());
            return Collections.emptySet();
        }
    }
}

