/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.save;

import com.adobe.granite.crx2oak.profile.ProfileStorageFormatConstants;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.profile.model.template.RawProfileTemplate;
import com.adobe.granite.crx2oak.profile.save.ProfileWriteException;
import com.adobe.granite.crx2oak.profile.save.ProfileWriter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemProfileWriter
implements ProfileWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemProfileWriter.class);
    private static final String THE_DIRECTORY_HASN_T_BEEN_CREATED_BY_SYSTEM_EXCEPTION_MESSAGE = "The directory hasn't been created by system.";
    private static final char COMMAND_OPTION_OR_ARGUMENT_SEPARATOR = ' ';
    private static final String SPACE = " ";
    private static final String QUOTE_STRING = "\"";

    @Override
    public void write(@Nonnull RawProfileTemplate rawProfileTemplateToWrite, @Nonnull String profileLocation) throws ProfileWriteException {
        Preconditions.checkNotNull((Object)rawProfileTemplateToWrite, (Object)"The profile template to write cannot be null");
        Preconditions.checkNotNull((Object)profileLocation, (Object)"The new profile location to safe cannot be null");
        File newProfileDirectory = new File(profileLocation);
        this.checkForExistingFile(newProfileDirectory);
        this.createProfile(newProfileDirectory, rawProfileTemplateToWrite);
    }

    private void createProfile(File newProfileDirectory, RawProfileTemplate rawProfileTemplateToWrite) {
        this.createProfileDirectory(newProfileDirectory);
        File osgiConfigurationsDirectory = this.createOsgiConfigurationsDirectory(newProfileDirectory);
        this.createOsgiConfigurations(osgiConfigurationsDirectory, rawProfileTemplateToWrite.getOsgiConfigurationsTemplates());
        File tagsDefinitionsDirectory = this.createTagsDefinitionsDirectory(newProfileDirectory);
        this.createTagsDefinitions(tagsDefinitionsDirectory, rawProfileTemplateToWrite.getTagsWithValues());
        this.createCommandLineFile(newProfileDirectory, rawProfileTemplateToWrite.getTemplatedCommandLineOptionsAndArguments());
    }

    private void createTagsDefinitions(File tagsDefinitionsDirectory, Map<String, String> tagsWithValues) {
        for (Map.Entry<String, String> tagDefinition : tagsWithValues.entrySet()) {
            this.createTagFile(tagsDefinitionsDirectory, tagDefinition);
        }
    }

    private void createTagFile(File tagsDefinitionsDirectory, Map.Entry<String, String> tagDefinition) {
        File tagFile = new File(tagsDefinitionsDirectory, tagDefinition.getKey());
        this.writeTagFile(tagDefinition.getValue(), tagFile);
    }

    private void writeTagFile(String value, File tagFile) {
        try {
            this.writeFileContent(value, tagFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Cannot write tag definition ({}) into profile.", (Object)tagFile.getAbsolutePath());
            throw new ProfileWriteException("Cannot write tag definition file: " + tagFile.getAbsolutePath(), e);
        }
    }

    private void createOsgiConfigurations(File osgiConfigurationsDirectory, Collection<OsgiConfiguration> osgiConfigurationsTemplates) {
        for (OsgiConfiguration osgiConfiguration : osgiConfigurationsTemplates) {
            this.createOsgiConfigurationFile(osgiConfigurationsDirectory, osgiConfiguration);
        }
    }

    private void createOsgiConfigurationFile(File osgiConfigurationsDirectory, OsgiConfiguration osgiConfiguration) {
        File osgiConfigurationFile = new File(osgiConfigurationsDirectory, osgiConfiguration.getDestinationFilename());
        this.writeOsgiConfigurationIntoFile(osgiConfiguration.getOsgiConfiguration(), osgiConfigurationFile);
    }

    private void writeOsgiConfigurationIntoFile(String osgiConfiguration, File osgiConfigurationFile) {
        try {
            this.writeFileContent(osgiConfiguration, osgiConfigurationFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Cannot write OSGi configuration ({}) into profile.", (Object)osgiConfigurationFile.getAbsolutePath());
            throw new ProfileWriteException("Cannot write OSGi configuration profile: " + osgiConfigurationFile.getAbsolutePath(), e);
        }
    }

    private void writeFileContent(String fileContent, String absolutePathToFile) throws IOException {
        Files.write(Paths.get(absolutePathToFile, new String[0]), fileContent.getBytes(ProfileStorageFormatConstants.PROFILE_CHARSET), new OpenOption[0]);
    }

    private void createCommandLineFile(File newProfileDirectory, List<String> templatedCommandLineOptionsAndArguments) {
        try {
            this.createCommandLineFileUnchecked(newProfileDirectory, templatedCommandLineOptionsAndArguments);
        }
        catch (IOException e) {
            String theProfileFilePath = newProfileDirectory + File.separator + "cmdline";
            LOGGER.error("Cannot create command line profile file ({}). Internal or system error.", (Object)theProfileFilePath);
            throw new ProfileWriteException("Cannot create profile file: " + theProfileFilePath);
        }
    }

    private void createCommandLineFileUnchecked(File newProfileDirectory, List<String> templatedCommandLineOptionsAndArguments) throws IOException {
        File commandLineFile = new File(newProfileDirectory, "cmdline");
        String commandLine = Joiner.on((char)' ').join(this.quoteStringsContainingSpaces(templatedCommandLineOptionsAndArguments));
        this.writeFileContent(commandLine, commandLineFile.getAbsolutePath());
    }

    private Iterable<String> quoteStringsContainingSpaces(List<String> templatedCommandLineOptionsAndArguments) {
        return Iterables.transform(templatedCommandLineOptionsAndArguments, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String commandLineArgumentOrOption) {
                return commandLineArgumentOrOption.contains(FilesystemProfileWriter.SPACE) ? FilesystemProfileWriter.QUOTE_STRING + commandLineArgumentOrOption + FilesystemProfileWriter.QUOTE_STRING : commandLineArgumentOrOption;
            }
        });
    }

    private File createTagsDefinitionsDirectory(File newProfileDirectory) {
        File tagsDefinitionsDirectory = new File(newProfileDirectory, "tags");
        tagsDefinitionsDirectory.mkdir();
        if (!tagsDefinitionsDirectory.exists() && !tagsDefinitionsDirectory.isDirectory()) {
            LOGGER.error("Cannot create tags definitions profile directory ({}). Internal or system error.", (Object)tagsDefinitionsDirectory.getAbsolutePath());
            throw new ProfileWriteException(THE_DIRECTORY_HASN_T_BEEN_CREATED_BY_SYSTEM_EXCEPTION_MESSAGE);
        }
        return tagsDefinitionsDirectory;
    }

    private File createOsgiConfigurationsDirectory(File newProfileDirectory) {
        File osgiConfigurationsDirectory = new File(newProfileDirectory, "osgi-configs");
        osgiConfigurationsDirectory.mkdir();
        if (!osgiConfigurationsDirectory.exists() && !osgiConfigurationsDirectory.isDirectory()) {
            LOGGER.error("Cannot create OSGi configurations profile directory ({}). Internal or system error.", (Object)osgiConfigurationsDirectory.getAbsolutePath());
            throw new ProfileWriteException(THE_DIRECTORY_HASN_T_BEEN_CREATED_BY_SYSTEM_EXCEPTION_MESSAGE);
        }
        return osgiConfigurationsDirectory;
    }

    private void createProfileDirectory(File newProfileDirectory) {
        newProfileDirectory.mkdirs();
        if (!newProfileDirectory.exists() && !newProfileDirectory.isDirectory()) {
            LOGGER.error("Cannot create profile directory ({}). Internal or system error.", (Object)newProfileDirectory.getAbsolutePath());
            throw new ProfileWriteException(THE_DIRECTORY_HASN_T_BEEN_CREATED_BY_SYSTEM_EXCEPTION_MESSAGE);
        }
    }

    private void checkForExistingFile(File newProfileDirectory) {
        if (newProfileDirectory.exists() && newProfileDirectory.isFile()) {
            LOGGER.error("Cannot create profile (directory) in a path that is a file: {}", (Object)newProfileDirectory.getAbsolutePath());
            throw new ProfileWriteException("Cannot create directory in place of existing file.");
        }
    }
}

