/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.tags;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.profile.TagsProvider;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRX2DataStoreTagProvider
implements TagsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRX2DataStoreTagProvider.class);
    private static final String MAIN_SLING_REPOSITORY_FOLDER = "repository";
    private static final String MAIN_SLING_REPOSITORY_PATH = "repository" + File.separator;
    private static final String CRX2_DATASTORE_FOLDER = MAIN_SLING_REPOSITORY_PATH + "repository" + File.separator + "datastore";
    private static final String REPOSITORY_XML_PATH = MAIN_SLING_REPOSITORY_PATH + "repository.xml";
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String HANDLED_OPTION = CRX2OakOption.CRX2_DATA_STORE.option;
    private static final int ONE_ELEMENT = 1;

    @Override
    public Map<String, String> provideTags(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        String slingHome = (String)input.get(Topics.SLING_HOME).or((Object)"");
        String slingHomeDetectionOptions = input.require(Topics.SLING_HOME_DETECTION_OPTIONS).toString();
        return options.has(HANDLED_OPTION) ? this.getCRX2DataStorePathAsTags(options, slingHomeDetectionOptions, slingHome) : EMPTY_MAP;
    }

    private Map<String, String> getCRX2DataStorePathAsTags(OptionSet options, String slingHomeDetectionOptions, String slingHome) {
        List<String> optionValues = CliUtils.getOptionValuesAsStrings(HANDLED_OPTION, options);
        return optionValues.isEmpty() ? EMPTY_MAP : this.getMapOfCRX2DataStorePathPerTagName(optionValues, slingHome, slingHomeDetectionOptions);
    }

    private Map<String, String> getMapOfCRX2DataStorePathPerTagName(List<String> tagNames, String slingHome, String slingHomeDetectionOptions) {
        LOGGER.debug("Trying to detect CRX2 datastore.");
        return StringUtils.isEmpty((CharSequence)slingHome) ? this.returnEmptyMapReportingMissingSlingHomePath(slingHomeDetectionOptions, tagNames) : this.getMapOfCRX2DataStorePathPerTagName(tagNames, slingHome);
    }

    private Map<String, String> getMapOfCRX2DataStorePathPerTagName(List<String> tagNames, String slingHomePath) {
        Optional<String> optionalCrx2DataStore = this.getCRX2DataStorePath(slingHomePath);
        return optionalCrx2DataStore.isPresent() ? this.createTagsDefinitions(tagNames, (String)optionalCrx2DataStore.get()) : EMPTY_MAP;
    }

    private Map<String, String> createTagsDefinitions(List<String> tagNames, String contantValue) {
        LOGGER.debug("Populating CRX2 data store path under the following tag names: {}.", tagNames);
        HashMap<String, String> crx2DataStoreTags = new HashMap<String, String>();
        for (String tagName : tagNames) {
            crx2DataStoreTags.put(tagName, contantValue);
        }
        return crx2DataStoreTags;
    }

    private Map<String, String> returnEmptyMapReportingMissingSlingHomePath(String slingHomeDetectionOptions, List<String> tagNames) {
        LOGGER.error("Sling Home path was not provided ({}) or the current tool run mode is not {}. Cannot create template tags with CRX2 data store path with the following names: {}", new Object[]{slingHomeDetectionOptions, RunMode.QUICKSTART_EXTENSION, tagNames});
        return EMPTY_MAP;
    }

    private Optional<String> getCRX2DataStorePath(String slingHome) {
        File repositoryXml = new File(slingHome + File.separator + REPOSITORY_XML_PATH);
        return !repositoryXml.isFile() && !repositoryXml.exists() ? Optional.absent() : this.getCRX2DataStorePathFromRepositoryDescriptorOrDefaultOne(slingHome, repositoryXml);
    }

    private Optional<String> getCRX2DataStorePathFromRepositoryDescriptorOrDefaultOne(String slingHome, File repositoryXml) {
        try {
            Optional path = this.getCRX2DataStorePathFromRepositoryDescriptorUnchecked(repositoryXml);
            return path.isPresent() ? path : Optional.of((Object)this.getDefaultCRX2DataStorePath(slingHome));
        }
        catch (IOException e) {
            LOGGER.error("Unable to parse CRX2 repository configuration " + repositoryXml.getAbsolutePath(), (Throwable)e);
            return Optional.absent();
        }
    }

    private Optional<String> getCRX2DataStorePathFromRepositoryDescriptorUnchecked(File repositoryXml) throws IOException {
        Document document = Jsoup.parse((File)repositoryXml, (String)"UTF-8");
        Elements elements = document.getElementsByTag("DataStore");
        if (elements.size() != 1) {
            LOGGER.error(String.format("Invalid CRX2 repository configuration at %s - detected %d DataStore configurations.", repositoryXml.getAbsolutePath(), elements.size()));
            return Optional.absent();
        }
        return this.getCRX2DataStorePathFromDataStoreXmlElement(elements.first());
    }

    private Optional<String> getCRX2DataStorePathFromDataStoreXmlElement(Element dataStore) {
        Elements dataStoreConfig = dataStore.children();
        for (Element dataStoreParameter : dataStoreConfig) {
            Optional<String> path = this.checkForDataStorePathElement(dataStoreParameter);
            if (!path.isPresent()) continue;
            return path;
        }
        return Optional.absent();
    }

    private Optional<String> checkForDataStorePathElement(Element dataStoreParameter) {
        LOGGER.trace("Analyzing data store parameter: {}", (Object)dataStoreParameter.nodeName());
        return "path".equals(dataStoreParameter.attr("name")) ? this.getDataStorePathValueIfNotEmpty(dataStoreParameter) : Optional.absent();
    }

    private Optional<String> getDataStorePathValueIfNotEmpty(Element dataStoreParameter) {
        LOGGER.trace("Checking path value of: {}", (Object)dataStoreParameter.nodeName());
        String path = dataStoreParameter.attr("value");
        return StringUtils.isNotEmpty((CharSequence)path) ? Optional.of((Object)this.enforceFileSeparatorForOsgiConfiguration(path)) : Optional.absent();
    }

    private String getDefaultCRX2DataStorePath(String slingHome) {
        LOGGER.trace("Returning default data store location.");
        File slingHomeFolder = new File(slingHome);
        String defaultPath = "." + File.separator + slingHomeFolder.getName() + File.separator + CRX2_DATASTORE_FOLDER;
        return this.enforceFileSeparatorForOsgiConfiguration(defaultPath);
    }

    private String enforceFileSeparatorForOsgiConfiguration(String path) {
        return StringUtils.replace((String)path, (String)File.separator, (String)"/");
    }
}

