/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.tags;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.profile.TagsProvider;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTagHandler
extends InputAggregatingComponent
implements TagsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineTagHandler.class);
    private static final int EXPECTED_NUMBER_OF_TOKENS = 1;
    private static final int FROM_SECOND_ELEMENT_INDEX = 1;
    public static final char TAG_NAME_AND_VALUE_SEPARATOR = '=';
    private static final String EXAMPLE_TAG_NAME = "tagname";
    private static final String EXAMPLE_TAG_VALUE = "tagvalue";

    @Override
    protected PipeData preprocess(PipeData input) {
        OptionSet parsedOptions = input.require(Topics.OPTION_SET);
        List<String> tagNames = this.getDeclaredOptionValuesAsStrings(parsedOptions, CRX2OakOption.TAG_NAME.option);
        List<String> tagValues = this.getDeclaredOptionValuesAsStrings(parsedOptions, CRX2OakOption.TAG_VALUE.option);
        List<String> tagDefinitionsOptions = this.getShortTagDefinitionOptions(parsedOptions);
        Map<String, String> tagDefinitions = this.parseTagDefinitions(tagDefinitionsOptions);
        return this.checkForUnbalancedTagOptions(tagNames, tagValues) ? this.returnEmptyMapAndReportInvalidUsageOfTagNameAndTagValue() : this.checkForTagIncompleteDefinitions(tagDefinitionsOptions, tagDefinitions);
    }

    private boolean checkForUnbalancedTagOptions(List<String> tagNames, List<String> tagValues) {
        return tagNames.size() != tagValues.size();
    }

    private PipeData checkForTagIncompleteDefinitions(List<String> tagDefinitionsOptions, Map<String, String> tagDefinitions) {
        return tagDefinitions.size() < tagDefinitionsOptions.size() ? this.returnEmptyMapAndReportInvalidUsageOfTagDefinition() : PipeData.EMPTY;
    }

    private PipeData returnEmptyMapAndReportInvalidUsageOfTagNameAndTagValue() {
        LOGGER.error("Illegal number of options specified. {} and {} must be specified in pairs.", (Object)CRX2OakOption.TAG_NAME.dashedOption, (Object)CRX2OakOption.TAG_VALUE.dashedOption);
        return Pipeline.streamClosed();
    }

    private PipeData returnEmptyMapAndReportInvalidUsageOfTagDefinition() {
        LOGGER.error("Illegal format specified in {} option. The correct format is: \n {} or \n {} or \n {}", new Object[]{CRX2OakOption.TAG_DEFINITION.dashedOption, String.format("%s %s%c%s", CRX2OakOption.TAG_DEFINITION.dashedOption, EXAMPLE_TAG_NAME, Character.valueOf('='), EXAMPLE_TAG_VALUE), String.format("%s %s", CRX2OakOption.TAG_DEFINITION.dashedOption, EXAMPLE_TAG_NAME), String.format("%s %s%c", CRX2OakOption.TAG_DEFINITION.dashedOption, EXAMPLE_TAG_NAME, Character.valueOf('='))});
        return Pipeline.streamClosed();
    }

    @Override
    public Map<String, String> provideTags(PipeData input) {
        return this.getAllTagsDeclaredDynamically(input.require(Topics.OPTION_SET));
    }

    private Map<String, String> getAllTagsDeclaredDynamically(OptionSet parsedOptions) {
        HashMap<String, String> allTagsDefinitions = new HashMap<String, String>();
        allTagsDefinitions.putAll(this.processAndGetTagsDefinedByShortOptionAtCommandLine(parsedOptions));
        allTagsDefinitions.putAll(this.processAndGetTagsDefinedByLongOptionsAtCommandLine(parsedOptions));
        return allTagsDefinitions;
    }

    private Map<String, String> processAndGetTagsDefinedByShortOptionAtCommandLine(OptionSet parsedOptions) {
        List<String> shortTagDefinitionOptions = this.getShortTagDefinitionOptions(parsedOptions);
        Map<String, String> tagDefinitions = this.parseTagDefinitions(shortTagDefinitionOptions);
        if (tagDefinitions.size() < shortTagDefinitionOptions.size()) {
            LOGGER.warn("Some tag definitions could not be correctly parsed");
            LOGGER.warn("The provided tag definitions are: {}", shortTagDefinitionOptions);
            LOGGER.warn("The effective tag definitions are: {}", tagDefinitions);
        }
        return tagDefinitions;
    }

    private Map<String, String> parseTagDefinitions(List<String> tagDefinitionsOptions) {
        HashMap<String, String> tagDefinitions = new HashMap<String, String>();
        for (String tagDefinitionOption : tagDefinitionsOptions) {
            tagDefinitions.putAll(this.parseTagDefinition(tagDefinitionOption));
        }
        return tagDefinitions;
    }

    private Map<String, String> parseTagDefinition(String tagDefinitionOption) {
        List nameWithValue = Splitter.on((char)'=').splitToList((CharSequence)tagDefinitionOption);
        return nameWithValue.size() < 1 ? Collections.emptyMap() : this.getTagDefinitionAsMap(nameWithValue);
    }

    private Map<String, String> getTagDefinitionAsMap(List<String> nameWithValue) {
        String name = nameWithValue.get(0);
        String value = Joiner.on((char)'=').join(this.getListWithoutHeadElement(nameWithValue));
        return StringUtils.isBlank((CharSequence)name) ? Collections.emptyMap() : Collections.singletonMap(name, value);
    }

    private List<String> getListWithoutHeadElement(List<String> nameWithValue) {
        return nameWithValue.subList(1, nameWithValue.size());
    }

    private List<String> getShortTagDefinitionOptions(OptionSet parsedOptions) {
        return this.getDeclaredOptionValuesAsStrings(parsedOptions, CRX2OakOption.TAG_DEFINITION.option);
    }

    private Map<String, String> processAndGetTagsDefinedByLongOptionsAtCommandLine(OptionSet parsedOptions) {
        List<String> tagNames = this.getDeclaredOptionValuesAsStrings(parsedOptions, CRX2OakOption.TAG_NAME.option);
        List<String> tagValues = this.getDeclaredOptionValuesAsStrings(parsedOptions, CRX2OakOption.TAG_VALUE.option);
        return tagNames.size() == tagValues.size() ? this.getMapFromEqualLists(tagNames, tagValues) : this.designateLimitedTagsDefinitionsMap(tagNames, tagValues);
    }

    private Map<String, String> designateLimitedTagsDefinitionsMap(List<String> tagNames, List<String> tagValues) {
        LOGGER.warn("The incorrect (not the same) number of {} and {} specified.  Please make sure both options are specified in pairs (equally). You specified the following tag names {} and tag values {}.", new Object[]{CRX2OakOption.TAG_NAME.dashedOption, CRX2OakOption.TAG_VALUE.dashedOption, tagNames, tagValues});
        int numberOfTagsDefinitionsPossibleToCreate = Math.min(tagNames.size(), tagValues.size());
        Map<String, String> mapFromLists = this.getMapFromLists(tagNames, tagValues, numberOfTagsDefinitionsPossibleToCreate);
        LOGGER.warn("The following limited list of tag definitions was created: {}", mapFromLists);
        return mapFromLists;
    }

    private Map<String, String> getMapFromEqualLists(List<String> tagNames, List<String> tagValues) {
        return this.getMapFromLists(tagNames, tagValues, tagNames.size());
    }

    private Map<String, String> getMapFromLists(List<String> tagNames, List<String> tagValues, int numberOfListElementsToCombine) {
        HashMap<String, String> additionalTags = new HashMap<String, String>();
        for (int idx = 0; idx < numberOfListElementsToCombine; ++idx) {
            additionalTags.put(tagNames.get(idx), tagValues.get(idx));
        }
        return additionalTags;
    }

    private List<String> getDeclaredOptionValuesAsStrings(OptionSet parsedOptions, String option) {
        return parsedOptions.has(option) ? CliUtils.getOptionValuesAsStrings(option, parsedOptions) : Collections.emptyList();
    }
}

