/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.profile.tags;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.profile.TagsProvider;
import com.adobe.granite.crx2oak.profile.process.TagProfileProcessor;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakFileDataStoreTagProvider
implements TagsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OakFileDataStoreTagProvider.class);
    private static final String FDS_OSGI_CONFIG_REGEXP_FILTER = "FileDataStore\\.config";
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String OSGI_CONFIG_FILE_SEPARATOR_IN_PATH = "/";
    private static final String DEFAULT_REPOSITORY_DIR_NAME = "repository";
    private static final String DEFAULT_DATA_STORE_DIR_NAME = "datastore";
    private static final String CURRENT_PATH_SYMBOL = ".";
    private static final char PROP_KEY_VALUE_DELIM = '=';
    private static final char PROP_VALUE_QUOTE_CHAR = '\"';
    private static final int MIN_NUMBER_OF_REQUIRED_TOKENS = 2;
    private static final int PROP_NAME_1ST_TOKEN_IDX = 0;
    private static final int PROP_VALUE_2ND_TOKEN_IDX = 1;
    private static final String DATASTORE_PATH_PROPERTY_NAME = "path";
    private static final char PROP_VALUE_IGNORED_CHAR = ' ';

    @Override
    public Map<String, String> provideTags(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        List<String> tagNamesFromCommandLine = this.getTagNamesFromCommandLine(options);
        return tagNamesFromCommandLine.isEmpty() ? EMPTY_MAP : this.getFileDataStoreTags(tagNamesFromCommandLine, (String)input.get(Topics.SLING_HOME).or((Object)""));
    }

    private Map<String, String> getFileDataStoreTags(List<String> tagNamesFromCommandLine, String slingHomePath) {
        Optional<File> slingHome = this.getSlingHome(slingHomePath);
        return slingHome.isPresent() ? this.getFileDataStoreTagsFromSlingHome((File)slingHome.get(), tagNamesFromCommandLine) : this.returnEmptyMapWithMissingSlingHomeWarning(tagNamesFromCommandLine);
    }

    private Map<String, String> returnEmptyMapWithMissingSlingHomeWarning(List<String> tagNamesFromCommandLine) {
        LOGGER.warn("Cannot find and detect Oak FileDataStore path as SLING_HOME was not defined.");
        String format = this.getNotEvaluatedTagsMessage(tagNamesFromCommandLine);
        LOGGER.warn(format);
        LOGGER.warn("Are you running tool in quickstart mode? Please refer to documentation.");
        return EMPTY_MAP;
    }

    private List<String> getTagNamesFromCommandLine(OptionSet parsedOptions) {
        return CliUtils.getOptionValuesAsStrings(CRX2OakOption.OAK_FILE_DATA_STORE.option, parsedOptions);
    }

    private Map<String, String> getFileDataStoreTagsFromSlingHome(File slingHomeFile, List<String> tagNames) {
        Optional<File> fdsFile = this.getFDSOsgiConfigurationFile(this.getSlingOsgiConfigurationFolder(slingHomeFile));
        return fdsFile.isPresent() && !tagNames.isEmpty() ? this.getTags(tagNames, this.getFileDataStorePath(slingHomeFile, (File)fdsFile.get())) : this.returnNoTagsDueToMissingFdsConfig(tagNames, slingHomeFile);
    }

    private String getFileDataStorePath(File slingHomeFile, File configFile) {
        Optional<String> optPath = this.getPathFromConfig(configFile);
        return optPath.isPresent() ? (String)optPath.get() : this.getDefaultFDSPath(slingHomeFile.getName());
    }

    private Map<String, String> returnNoTagsDueToMissingFdsConfig(List<String> tagNames, File slingHomeFile) {
        LOGGER.debug("Cannot find FileDataStore configuration under SLING_HOME: {}", (Object)slingHomeFile.getAbsolutePath());
        LOGGER.debug(this.getNotEvaluatedTagsMessage(tagNames));
        return EMPTY_MAP;
    }

    private Optional<File> getFDSOsgiConfigurationFile(File slingOsgiConfigurationFolder) {
        return this.findFirst(slingOsgiConfigurationFolder.exists() ? FileUtils.listFiles((File)slingOsgiConfigurationFolder, (IOFileFilter)new RegexFileFilter(FDS_OSGI_CONFIG_REGEXP_FILTER), (IOFileFilter)TrueFileFilter.INSTANCE) : this.returnEmptyListDueToMissingFdsConfig(slingOsgiConfigurationFolder));
    }

    private List<File> returnEmptyListDueToMissingFdsConfig(File slingOsgiConfigurationFolder) {
        LOGGER.debug("Cannot find FileDataStore configuration under Sling Launchpad config: {}", (Object)slingOsgiConfigurationFolder.getAbsolutePath());
        return Collections.emptyList();
    }

    private String getNotEvaluatedTagsMessage(List<String> tagNames) {
        String templateTags = Joiner.on((String)", ").join(TagProfileProcessor.formatAsTemplateTags(tagNames));
        return String.format("The following tag names won't be evaluated: %s.", templateTags);
    }

    private Optional<File> findFirst(Collection<File> files) {
        return files.isEmpty() ? Optional.absent() : Optional.of((Object)files.iterator().next());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> getPathFromConfig(File configFile) {
        LOGGER.debug("Reading Oak FDS OSGi config file: {}", (Object)configFile);
        String configFilePath = configFile.getAbsolutePath();
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            Optional<String> optional = this.getPathUsingBufferedReader(configFilePath, br);
            return optional;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not open config: {}", (Object)configFilePath, (Object)e);
            return Optional.absent();
        }
        catch (IOException e) {
            LOGGER.warn("Could not read config: {}", (Object)configFilePath, (Object)e);
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> getPathUsingBufferedReader(String configFilePath, BufferedReader reader) {
        Optional<String> optPath = Optional.absent();
        try {
            optPath = this.readPathFromConfig(reader, configFilePath);
        }
        catch (IOException e) {
            LOGGER.warn("Could not read config: {}", (Object)configFilePath, (Object)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return optPath;
    }

    private Optional<String> readPathFromConfig(BufferedReader reader, String configFilePath) throws IOException {
        String line;
        Optional<String> optPath = Optional.absent();
        while ((line = reader.readLine()) != null && !optPath.isPresent()) {
            optPath = this.getPathFromPropertyDefinition(line);
        }
        if (!optPath.isPresent()) {
            LOGGER.warn("The path property was not found in the following config file: {}", (Object)configFilePath);
        } else {
            LOGGER.debug("The following path: '{}' was found in the config: {}", optPath.get(), (Object)configFilePath);
        }
        return optPath;
    }

    private Optional<String> getPathFromPropertyDefinition(String propertyDefinition) {
        StrTokenizer t = new StrTokenizer(propertyDefinition, '=', '\"').setIgnoredChar(' ');
        List tokens = t.getTokenList();
        return tokens.size() >= 2 ? this.getPathFromProperty((String)tokens.get(0), (String)tokens.get(1)) : Optional.absent();
    }

    private Optional<String> getPathFromProperty(String propName, String propValue) {
        return propName.trim().equals(DATASTORE_PATH_PROPERTY_NAME) && StringUtils.isNotBlank((CharSequence)propValue) ? Optional.of((Object)propValue.trim()) : Optional.absent();
    }

    private String getDefaultFDSPath(String slingHomeFolderName) {
        String defaultFdsPath = CURRENT_PATH_SYMBOL + StringUtils.appendIfMissing((String)StringUtils.wrap((String)slingHomeFolderName, (String)OSGI_CONFIG_FILE_SEPARATOR_IN_PATH), (CharSequence)OSGI_CONFIG_FILE_SEPARATOR_IN_PATH, (CharSequence[])new CharSequence[0]) + StringUtils.repeat((String)"repository/", (int)2) + DEFAULT_DATA_STORE_DIR_NAME;
        LOGGER.info("The default location ({}) of FDS path will be used based on the SLING_HOME folder name: {}", (Object)defaultFdsPath, (Object)slingHomeFolderName);
        return defaultFdsPath;
    }

    private Map<String, String> getTags(List<String> names, String value) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (String name : names) {
            tags.put(name, value);
        }
        return tags;
    }

    private Optional<File> getSlingHome(String slingHomePath) {
        return StringUtils.isNotBlank((CharSequence)slingHomePath) ? Optional.of((Object)new File(slingHomePath)) : Optional.absent();
    }

    private File getSlingOsgiConfigurationFolder(File slingHome) {
        return new File(new File((File)Preconditions.checkNotNull((Object)slingHome), "launchpad"), "config");
    }
}

