/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.profile.model.osgi.OsgiConfiguration;
import com.adobe.granite.crx2oak.util.FilesystemUtils;
import com.adobe.granite.crx2oak.util.UncheckedIOException;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiConfigurationsInstaller
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiConfigurationsInstaller.class);
    public static final String AEM_SLING_INSTALL_DIRECTORY_NAME = "install";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final Set<OsgiConfiguration> EMPTY_SET = Collections.emptySet();
    private static final String BACKUP_SUFFIX = "-crx2oak-";

    @Override
    protected PipeData preprocess(PipeData input) {
        Collection configs = (Collection)input.get(Topics.INSTALLABLE_OSGI_CONFIGS).or(EMPTY_SET);
        return configs.isEmpty() ? this.doNothing() : this.prepareToOsgiConfigInstallation(input, configs);
    }

    private PipeData doNothing() {
        LOGGER.debug("Skipping {} as no OSGi configurations are ready to install", (Object)this.getClass().getSimpleName());
        return PipeData.EMPTY;
    }

    private PipeData prepareToOsgiConfigInstallation(PipeData input, Collection<OsgiConfiguration> configs) {
        List actions = (List)input.get(Topics.POST_MIGRATION_ACTIONS).or(new ArrayList());
        Optional<String> slingHome = input.get(Topics.SLING_HOME);
        return slingHome.isPresent() ? this.preprocessOsgiConfigs(configs, actions, (String)slingHome.get()) : this.returnSlingHomeNotPresent(input);
    }

    private PipeData returnSlingHomeNotPresent(PipeData input) {
        LOGGER.error("The Sling Home hasn't been detected. It is possible you are running the tool in the wrong run mode ({}). ", (Object)this.getRunMode(input));
        return Pipeline.streamClosed(input);
    }

    private RunMode getRunMode(PipeData input) {
        return (RunMode)((Object)input.get(Topics.RUN_MODE).or((Object)RunMode.STANDALONE));
    }

    private PipeData preprocessOsgiConfigs(Collection<OsgiConfiguration> configs, List<PipelineComponent> actions, String slingHome) {
        return configs.isEmpty() ? this.logNoAction() : this.installOsgiConfigs(configs, actions, slingHome);
    }

    private PipeData installOsgiConfigs(Collection<OsgiConfiguration> configs, List<PipelineComponent> actions, String slingHome) {
        this.logOsgiConfigurationsToInstall(configs);
        File slingInstallFolder = new File(slingHome + File.separator + AEM_SLING_INSTALL_DIRECTORY_NAME);
        return this.ensureSlingInstallFolderIsPresent(slingInstallFolder) ? this.returnOsgiInstallerPostMigrationActions(configs, actions, slingInstallFolder) : Pipeline.streamClosed();
    }

    private PipeData logNoAction() {
        LOGGER.info("Skipping {} as no OSGi configurations has been identified to install.", (Object)this.getClass().getSimpleName());
        return PipeData.EMPTY;
    }

    private PipeData returnOsgiInstallerPostMigrationActions(Collection<OsgiConfiguration> osgiConfigurationsToInstall, List<PipelineComponent> existingActions, File slingInstallFolder) {
        ArrayList<PipelineComponent> postActions = new ArrayList<PipelineComponent>(existingActions);
        for (OsgiConfiguration osgiConfiguration : osgiConfigurationsToInstall) {
            postActions.add(this.getOsgiConfigInstallationAction(osgiConfiguration, slingInstallFolder));
        }
        return PipeData.put(Topics.POST_MIGRATION_ACTIONS, postActions).toPipe();
    }

    private boolean cannotBeCreated(File slingInstallFolder) {
        return !slingInstallFolder.exists() && !this.createSlingInstallDirectoryAndReturnIfExists(slingInstallFolder);
    }

    private boolean createSlingInstallDirectoryAndReturnIfExists(File slingInstallFolder) {
        slingInstallFolder.mkdirs();
        return slingInstallFolder.exists() && slingInstallFolder.isDirectory();
    }

    private boolean ensureSlingInstallFolderIsPresent(File slingInstallFolder) {
        return !this.cannotBeCreated(slingInstallFolder) || this.returnSlingInstallFolderNotCreated(slingInstallFolder);
    }

    private boolean returnSlingInstallFolderNotCreated(File slingInstallFolder) {
        LOGGER.error("The Sling Install Directory: {} necessary for OSGi configurations cannot be created.", (Object)slingInstallFolder.getAbsolutePath());
        return false;
    }

    private void logOsgiConfigurationsToInstall(Collection<OsgiConfiguration> osgiConfigsToInstall) {
        Iterable filenames = Iterables.transform(osgiConfigsToInstall, (Function)new Function<OsgiConfiguration, String>(){

            public String apply(@Nullable OsgiConfiguration osgiConfiguration) {
                return osgiConfiguration == null ? "" : osgiConfiguration.getDestinationFilename();
            }
        });
        LOGGER.debug("The following OSGi configurations (files) has been scheduled to install after migration: {}", (Object)filenames);
    }

    private PipelineComponent getOsgiConfigInstallationAction(final OsgiConfiguration osgiConfiguration, final File slingInstallFolder) {
        return new InputAggregatingComponent(){

            @Override
            public PipeData preprocess(PipeData input) {
                File osgiConfigurationInstallableFile = new File(slingInstallFolder, osgiConfiguration.getDestinationFilename());
                LOGGER.info("Scheduling OSGi configuration to install for next AEM run: {}", (Object)osgiConfiguration.getDestinationFilename());
                return this.checkAndWriteOsgiConfigurationIntoFile(osgiConfiguration.getOsgiConfiguration(), osgiConfigurationInstallableFile, input);
            }

            private PipeData checkAndWriteOsgiConfigurationIntoFile(String osgiConfiguration2, File osgiConfigurationFile, PipeData input) {
                try {
                    String theConfigurationContent = FilesystemUtils.rewriteFileLines(osgiConfiguration2);
                    this.writeIfNeeded(osgiConfigurationFile, theConfigurationContent);
                    return PipeData.EMPTY;
                }
                catch (RuntimeException e) {
                    String warning = this.getOsgiInstallerWarning(osgiConfiguration2, osgiConfigurationFile, e);
                    return PipeData.join(input, Topics.WARNINGS, warning).toPipe();
                }
            }

            private void writeIfNeeded(File osgiConfigurationFile, String theConfigurationContent) {
                if (FilesystemUtils.areTheSame(osgiConfigurationFile, theConfigurationContent)) {
                    LOGGER.info("The existing OSGi configuration is already correct. Skipping installation of: {}", (Object)osgiConfigurationFile.getAbsolutePath());
                } else {
                    this.write(osgiConfigurationFile, theConfigurationContent);
                }
            }

            private void write(File osgiConfigurationFile, String theConfigurationContent) {
                try {
                    this.informAboutPossibleBackup(osgiConfigurationFile);
                    FilesystemUtils.backup(osgiConfigurationFile, OsgiConfigurationsInstaller.BACKUP_SUFFIX);
                    Files.write(Paths.get(osgiConfigurationFile.getAbsolutePath(), new String[0]), theConfigurationContent.getBytes(UTF8_CHARSET), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            private void informAboutPossibleBackup(File osgiConfigurationFile) {
                if (osgiConfigurationFile.exists()) {
                    LOGGER.info("The OSGi file already exist and it will be backed up first: {}", (Object)osgiConfigurationFile.getAbsolutePath());
                }
            }

            private String getOsgiInstallerWarning(String osgiConfig, File osgiConfigFile, Exception exception) {
                LOGGER.error("Cannot backup or/and write OSGi configuration to install folder: {}", (Object)osgiConfigFile.getAbsolutePath(), (Object)exception);
                LOGGER.error("You might need to double check and manually configure the following OSGi configuration: {}\n{}", (Object)osgiConfigFile.getName(), (Object)osgiConfig);
                return String.format("The migration process was not able to backup/write an OSGi configuration in install folder: %s", osgiConfigFile.getAbsolutePath());
            }
        };
    }
}

