/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class Path
implements Cloneable {
    private List<String> segments;

    private Path(Path original) {
        this.segments = new ArrayList<String>(original.segments);
    }

    public Path(String path) {
        this();
        String pathToSplit = path;
        if (pathToSplit.charAt(0) == '/') {
            pathToSplit = pathToSplit.substring(1);
        }
        for (String segment : Splitter.on((char)'/').split((CharSequence)pathToSplit)) {
            this.segments.add(segment);
        }
    }

    public Path() {
        this.segments = new ArrayList<String>();
    }

    public void addSegment(String segment) {
        this.segments.add(segment);
    }

    public void removeSegment() {
        if (!this.segments.isEmpty()) {
            this.segments.remove(this.segments.size() - 1);
        }
    }

    public boolean sameLine(Path other) {
        int minimalSize = Math.min(this.segments.size(), other.segments.size());
        for (int i = 0; i < minimalSize; ++i) {
            if (this.segments.get(i).equals(other.segments.get(i))) continue;
            return false;
        }
        return true;
    }

    public NodeBuilder getBuilder(NodeBuilder rootBuilder) {
        NodeBuilder builder = rootBuilder;
        for (String segment : this.segments) {
            builder = builder.getChildNode(segment);
        }
        return builder;
    }

    public NodeBuilder getParentBuilder(NodeBuilder rootBuilder) {
        NodeBuilder builder = rootBuilder;
        Iterator<String> it = this.segments.iterator();
        while (it.hasNext()) {
            String segment = it.next();
            if (!it.hasNext()) break;
            builder = builder.getChildNode(segment);
        }
        return builder;
    }

    public Path clone() {
        return new Path(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Path rhs = (Path)obj;
        return rhs.segments.equals(this.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return '/' + Joiner.on((char)'/').join(this.segments);
    }
}

