/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineExecutor;
import com.adobe.granite.crx2oak.sling.RunModeOperations;
import com.adobe.granite.crx2oak.sling.SlingOptionsFileFinder;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.settings.impl.RunModes;
import org.apache.sling.settings.impl.RunModesTransformer;
import org.apache.sling.settings.impl.SlingOptionsFileReader;
import org.apache.sling.settings.impl.SlingOptionsFileWriter;
import org.apache.sling.settings.impl.SlingOptionsReadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunModesRewriter
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunModesRewriter.class);
    private static final CRX2OakOption DROP_RUN_MODE_OPTION = CRX2OakOption.DROP_RUN_MODE;
    private static final CRX2OakOption PROMOTE_RUN_MODE_OPTION = CRX2OakOption.PROMOTE_RUN_MODE;
    private static final CRX2OakOption INSTALL_RUN_MODE_OPTION = CRX2OakOption.INSTALL_RUN_MODE;
    private static final String DROP_OPT = RunModesRewriter.DROP_RUN_MODE_OPTION.option;
    private static final String PROMOTE_OPT = RunModesRewriter.PROMOTE_RUN_MODE_OPTION.option;
    private static final String INSTALL_OPT = RunModesRewriter.INSTALL_RUN_MODE_OPTION.option;
    private static final String DROP_DASHED_OPT = RunModesRewriter.DROP_RUN_MODE_OPTION.dashedOption;
    private static final String PROMOTE_DASHED_OPT = RunModesRewriter.PROMOTE_RUN_MODE_OPTION.dashedOption;
    private static final String COMPONENT_ERR_MSG = String.format("Cannot promote, drop or install run modes using: %s, %s or %s options.\n", PROMOTE_DASHED_OPT, DROP_DASHED_OPT, INSTALL_OPT);
    private static final List<String> PERSISTENCE_RUN_MODES = ImmutableList.of((Object)"crx3tar", (Object)"crx3mongo");
    private static final PipeData.Topic<List<PipelineComponent>> ACTIONS = Topics.POST_MIGRATION_ACTIONS;
    private final SlingOptionsFileFinder finder;
    private final SlingOptionsFileReader reader;
    private final SlingOptionsFileWriter writer;

    public RunModesRewriter(SlingOptionsFileFinder finder, SlingOptionsFileReader reader, SlingOptionsFileWriter writer) {
        this.finder = Objects.requireNonNull(finder);
        this.reader = Objects.requireNonNull(reader);
        this.writer = Objects.requireNonNull(writer);
    }

    @Override
    public PipeData preprocess(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        return options.has(PROMOTE_OPT) || options.has(DROP_OPT) || options.has(INSTALL_OPT) ? this.transformRunModes(options, input) : input;
    }

    private PipeData transformRunModes(OptionSet options, PipeData input) {
        String slingHome = (String)input.get(Topics.SLING_HOME).or((Object)"");
        Map<String, String> detectionOptions = input.require(Topics.SLING_HOME_DETECTION_OPTIONS);
        return StringUtils.isBlank((CharSequence)slingHome) ? this.abortProcessingDueToMissingSlingHome(detectionOptions) : this.joinPostMigrationTasks(input, this.transformRunModes(slingHome, options));
    }

    private PipeData joinPostMigrationTasks(PipeData input, PipeData currentInput) {
        return input.get(ACTIONS).isPresent() ? PipeData.join(input, ACTIONS, currentInput).toPipe() : currentInput;
    }

    private PipeData transformRunModes(String slingHome, OptionSet options) {
        List<String> promotions = CliUtils.getOptionValuesAsStrings(PROMOTE_OPT, options);
        List<String> drops = CliUtils.getOptionValuesAsStrings(DROP_OPT, options);
        List<String> installs = CliUtils.getOptionValuesAsStrings(INSTALL_OPT, options);
        return promotions.isEmpty() && drops.isEmpty() && installs.isEmpty() ? PipeData.EMPTY : this.transformRunModes(slingHome, new RunModeOperations(promotions, drops, installs));
    }

    private PipeData transformRunModes(String slingHome, RunModeOperations ops) {
        File slingHomeFile = new File(slingHome);
        return slingHomeFile.exists() ? this.transformRunModesOfSling(slingHomeFile, ops) : this.abortProcessingDueToInvalidSlingHome(slingHomeFile.getAbsolutePath());
    }

    private PipeData transformRunModesOfSling(File slingHome, RunModeOperations ops) {
        try {
            return this.transformRunModesOfSlingUnchecked(slingHome, ops);
        }
        catch (IOException e) {
            LOGGER.error("Cannot transform run modes. Could not canonicalize directory path: {}", (Object)slingHome.getAbsolutePath());
            return Pipeline.streamClosed();
        }
    }

    private PipeData transformRunModesOfSlingUnchecked(File slingHome, RunModeOperations ops) throws IOException {
        Collection<File> slingOptionsFiles = this.finder.getSlingOptionsFiles(slingHome.getCanonicalPath());
        this.warnAboutMultipleCandidates(slingOptionsFiles);
        if (slingOptionsFiles.isEmpty()) {
            return this.abortProcessingDueToSlingOptionsNotFound(slingHome);
        }
        return this.analyzeAndScheduleTransformersForMigration(slingOptionsFiles, ops);
    }

    private PipeData analyzeAndScheduleTransformersForMigration(Collection<File> slingOptionsFiles, RunModeOperations ops) {
        PipeData output = PipeData.EMPTY;
        for (File slingOptionFile : slingOptionsFiles) {
            Optional<PipelineComponent> pipelineComponent = this.analyzeAndScheduleTransformation(slingOptionFile, ops);
            output = pipelineComponent.isPresent() ? this.getPostMigrationPipelineExtension(output, (PipelineComponent)pipelineComponent.get()) : Pipeline.streamClosed(output);
        }
        return output;
    }

    private PipeData getPostMigrationPipelineExtension(PipeData input, PipelineComponent component) {
        return PipeData.use(input).join(input, ACTIONS, component).toPipe();
    }

    private Optional<PipelineComponent> analyzeAndScheduleTransformation(File slingOptionFile, RunModeOperations ops) {
        SlingOptionsReadResult readResult = this.reader.readOptions(slingOptionFile);
        return readResult.isSuccessful() ? Optional.of((Object)this.createTransformation(slingOptionFile, ops, readResult.getRunModes())) : this.returnEmptyPipelineComponent(slingOptionFile);
    }

    private PipelineComponent createTransformation(File slingOptionFile, RunModeOperations ops, RunModes runModes) {
        RunModesTransformer transformer = RunModesTransformer.transform(runModes);
        this.deactivateRunModes(ops.getDrops(), transformer);
        this.activateRunModes(ops.getPromotions(), transformer);
        this.installRunModes(ops.getInstalls(), transformer, PERSISTENCE_RUN_MODES);
        RunModes newRunModes = transformer.toSlingRunMode();
        if (runModes == newRunModes) {
            LOGGER.debug("Run modes after <-{}, +{}, ++{}> transformation are the same: {}.", new Object[]{ops.getDrops(), ops.getPromotions(), ops.getInstalls(), runModes});
        }
        LOGGER.debug("Going to transform runmodes:\nfrom:\n  {}\nusing function:\n  <-{},+{},++{}>\nto:\n  {}", new Object[]{runModes, ops.getDrops(), ops.getPromotions(), ops.getInstalls(), newRunModes});
        return this.createTransformationPipelineComponent(slingOptionFile, newRunModes);
    }

    private Optional<PipelineComponent> returnEmptyPipelineComponent(File slingOptionFile) {
        LOGGER.warn("Skipping run mode transformation in: {} due to not successful read.", (Object)slingOptionFile);
        return Optional.absent();
    }

    private PipelineComponent createTransformationPipelineComponent(final File slingOptionFile, final RunModes newModes) {
        return new PipelineExecutor(){

            @Override
            protected void run() {
                if (!slingOptionFile.exists() || this.isRewriteNeeded(slingOptionFile)) {
                    LOGGER.info("Writing AEM run modes to: {}", (Object)slingOptionFile.getAbsolutePath());
                    RunModesRewriter.this.writer.writeOptions(newModes, slingOptionFile);
                } else {
                    LOGGER.debug("Skipping rewriting run modes for {}. No modification was planned", (Object)slingOptionFile.getAbsolutePath());
                }
            }

            private boolean isRewriteNeeded(File slingOptionFile1) {
                SlingOptionsReadResult result = RunModesRewriter.this.reader.readOptions(slingOptionFile1);
                return !result.isSuccessful() || result.isSuccessful() && !Objects.equals(result.getRunModes(), newModes);
            }
        };
    }

    private void activateRunModes(Iterable<String> newModes, RunModesTransformer transformer) {
        for (String runModeToActivate : newModes) {
            transformer.activate(runModeToActivate);
        }
    }

    private void deactivateRunModes(Iterable<String> drops, RunModesTransformer transformer) {
        for (String runModeToDeactivate : drops) {
            transformer.deactivate(runModeToDeactivate);
        }
    }

    private void installRunModes(Iterable<String> installModes, RunModesTransformer transformer, List<String> runModeGroupExamples) {
        for (String runModeToInstall : installModes) {
            transformer.install(runModeToInstall, runModeGroupExamples);
        }
    }

    private PipeData abortProcessingDueToSlingOptionsNotFound(File slingHome) {
        LOGGER.error(COMPONENT_ERR_MSG + "  Could not find files with run modes under {}", (Object)slingHome.getAbsolutePath());
        return Pipeline.streamClosed();
    }

    private void warnAboutMultipleCandidates(Collection<File> slingOptionsFiles) {
        if (slingOptionsFiles.size() > 1) {
            LOGGER.warn("More than one sling option file is available but the expected is just one. Each following candidate will be transformed: {}", slingOptionsFiles);
        }
    }

    private PipeData abortProcessingDueToInvalidSlingHome(String slingHome) {
        LOGGER.error(COMPONENT_ERR_MSG + "  The Sling Home path '{}' is not reachable.", (Object)slingHome);
        return Pipeline.streamClosed();
    }

    private PipeData abortProcessingDueToMissingSlingHome(Map<String, String> detectionOptions) {
        String detectionMethods = Joiner.on((String)") or (").join(detectionOptions.entrySet());
        LOGGER.error(COMPONENT_ERR_MSG + "  The Sling Home path could not be detected and found via ({}).\n  In order to use those options you need to define Sling Home manually or use the tool in {} mode.", (Object)detectionMethods, (Object)RunMode.QUICKSTART_EXTENSION);
        return Pipeline.streamClosed();
    }
}

