/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.adobe.granite.crx2oak.sling.Path;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingFolderHook
extends EditorHook {
    private static final Logger log = LoggerFactory.getLogger(SlingFolderHook.class);

    public SlingFolderHook() {
        super(new EditorProvider(){

            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
                return new SlingFolderEditor(builder);
            }

            public String toString() {
                return "SlingFolderEditorProvider";
            }
        });
    }

    private static class SlingFolderEditor
    extends DefaultEditor {
        private static final Path SLING_FOLDER_PATH = new Path("/jcr:system/jcr:nodeTypes/sling:Folder");
        private final Path currentPath = new Path();
        private final NodeBuilder rootBuilder;

        public SlingFolderEditor(NodeBuilder builder) {
            this.rootBuilder = builder;
        }

        public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
            this.currentPath.addSegment(name);
            if (!this.currentPath.sameLine(SLING_FOLDER_PATH)) {
                this.currentPath.removeSegment();
                return null;
            }
            return this;
        }

        public void leave(NodeState before, NodeState after) throws CommitFailedException {
            if (SLING_FOLDER_PATH.equals(this.currentPath)) {
                this.swapPropertyDefinitions(this.currentPath.getBuilder(this.rootBuilder));
            }
            this.currentPath.removeSegment();
        }

        private void swapPropertyDefinitions(NodeBuilder slingFolder) {
            NodeBuilder def1 = slingFolder.getChildNode("jcr:propertyDefinition[1]");
            NodeBuilder def2 = slingFolder.getChildNode("jcr:propertyDefinition[2]");
            if (!def1.exists() || !def2.exists()) {
                return;
            }
            PropertyState s1 = def1.getProperty("jcr:multiple");
            PropertyState s2 = def2.getProperty("jcr:multiple");
            if (((Boolean)s1.getValue(Type.BOOLEAN)).booleanValue() && !((Boolean)s2.getValue(Type.BOOLEAN)).booleanValue()) {
                return;
            }
            def1.setProperty("jcr:multiple", (Object)true, Type.BOOLEAN);
            def2.setProperty("jcr:multiple", (Object)false, Type.BOOLEAN);
            log.info("Succesfully swapped sling:Folder property definitions");
        }
    }
}

