/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingHomeDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingHomeDetector.class);
    public static final String SLING_HOME_SYSTEM_PROPERTY = "qs.sling.home";
    public static final String SLING_HOME_ENVIRONMENTAL_VARIABLE = "SLING_HOME";

    public String detectSlingHomeFromEnvironment() {
        String slingHomeEnvironmentalVariable = System.getenv(SLING_HOME_ENVIRONMENTAL_VARIABLE);
        return SlingHomeDetector.getSystemPropertyOrDefaultValue(slingHomeEnvironmentalVariable);
    }

    public String getSlingHomeDetectionOptions() {
        ArrayList<String> detectionOptions = new ArrayList<String>();
        for (Map.Entry<String, String> detectionOption : SlingHomeDetector.getSlingHomeDetectionOptionsMap().entrySet()) {
            detectionOptions.add(String.format("%s %s", detectionOption.getValue(), detectionOption.getKey()));
        }
        return Joiner.on((String)" or ").join(detectionOptions);
    }

    private static String getSystemPropertyOrDefaultValue(String defaultValue) {
        Properties systemProperties = System.getProperties();
        return systemProperties.containsKey(SLING_HOME_SYSTEM_PROPERTY) ? systemProperties.getProperty(SLING_HOME_SYSTEM_PROPERTY) : defaultValue;
    }

    private static Map<String, String> getSlingHomeDetectionOptionsMap() {
        return ImmutableMap.of((Object)"JVM system property", (Object)SLING_HOME_SYSTEM_PROPERTY, (Object)"environmental variable", (Object)SLING_HOME_ENVIRONMENTAL_VARIABLE);
    }

    public static class SlingHomePipelineDetector
    extends InputAggregatingComponent {
        private SlingHomeDetector detector;

        public SlingHomePipelineDetector(SlingHomeDetector detector) {
            this.detector = Objects.requireNonNull(detector);
        }

        @Override
        public PipeData preprocess(PipeData input) {
            String slingHome = this.detector.detectSlingHomeFromEnvironment();
            boolean slingHomeDetected = StringUtils.isNotBlank((CharSequence)slingHome);
            if (slingHomeDetected) {
                LOGGER.info("Detected Quickstart/Sling instance in: {}", (Object)slingHome);
            }
            return PipeData.put(Topics.SLING_HOME_DETECTION_OPTIONS, SlingHomeDetector.getSlingHomeDetectionOptionsMap()).put(Topics.RUN_MODE, slingHomeDetected ? RunMode.QUICKSTART_EXTENSION : RunMode.STANDALONE).putOptionally(Topics.SLING_HOME, slingHomeDetected ? slingHome : null).toPipe();
        }
    }
}

