/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.sling;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineExecutor;
import com.adobe.granite.crx2oak.sling.SlingOptionsFileFinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingOptionsFileDeletionDelegator
extends InputAggregatingComponent {
    private static final Logger log = LoggerFactory.getLogger(SlingOptionsFileDeletionDelegator.class);
    private static final List<PipelineComponent> EMPTY_LIST = Collections.emptyList();
    private final SlingOptionsFileFinder slingOptionsFileFinder;

    public SlingOptionsFileDeletionDelegator(@Nonnull SlingOptionsFileFinder slingOptionsFileFinder) {
        this.slingOptionsFileFinder = (SlingOptionsFileFinder)Preconditions.checkNotNull((Object)slingOptionsFileFinder);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        return input.require(Topics.OPTION_SET).has(CRX2OakOption.DELETE_SLING_OPTIONS_FILE.option) ? this.validateAndReturnPostMigrationTask(input) : PipeData.EMPTY;
    }

    private PipeData validateAndReturnPostMigrationTask(PipeData input) {
        return input.get(Topics.SLING_HOME).isPresent() ? this.returnPostMigrationTask(input.require(Topics.SLING_HOME), this.getCurrentPostMigrationActions(input)) : this.doNothingAndReportMissingSlingHome();
    }

    private List<PipelineComponent> getCurrentPostMigrationActions(PipeData input) {
        return (List)input.get(Topics.POST_MIGRATION_ACTIONS).or(EMPTY_LIST);
    }

    private PipeData returnPostMigrationTask(String slingHome, List<PipelineComponent> currentActions) {
        return PipeData.put(Topics.POST_MIGRATION_ACTIONS, ImmutableList.builder().addAll(currentActions).add((Object)this.getSlingOptionsFileDeleterProcessor(slingHome)).build()).toPipe();
    }

    private PipeData doNothingAndReportMissingSlingHome() {
        log.error("Missing SLING_HOME path. Cannot handle: {} option.", (Object)CRX2OakOption.DELETE_SLING_OPTIONS_FILE.dashedOption);
        return PipeData.EMPTY;
    }

    PipelineComponent getSlingOptionsFileDeleterProcessor(final String slingHome) {
        return new PipelineExecutor(){

            @Override
            public void run() {
                Collection<File> files = SlingOptionsFileDeletionDelegator.this.slingOptionsFileFinder.getSlingOptionsFiles(slingHome);
                SimpleDateFormat fileRenameSDF = new SimpleDateFormat("yyyyMMdd-HHmmss");
                for (File f : files) {
                    File renamed = new File(f.getParent() + File.separator + f.getName() + ".SAVED-" + fileRenameSDF.format(new Date()));
                    log.info("Renaming {} to {}.", (Object)f.getPath(), (Object)renamed.getPath());
                    if (f.renameTo(renamed)) continue;
                    log.warn("Failed renaming {} to {}. Please attempt to do this manually before launching the migrated instance.", (Object)f.getPath(), (Object)renamed.getPath());
                }
            }
        };
    }
}

