/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;

public final class CliUtils {
    public static final String APP_GROUP_ID = "com.adobe.granite";
    public static final String APP_ARTIFACT_ID = "crx2oak";
    public static final String UNKNOWN_VERSION = "unknown version";
    public static final String VERSION_PROPERTY_NAME = "version";

    private CliUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getVersion() {
        InputStream stream = MigrationCliArguments.class.getResourceAsStream("/META-INF/maven/com.adobe.granite/crx2oak/pom.properties");
        if (stream != null) {
            String string;
            try {
                Properties properties = new Properties();
                properties.load(stream);
                String versionValue = properties.getProperty(VERSION_PROPERTY_NAME);
                string = StringUtils.isNotEmpty((CharSequence)versionValue) ? versionValue : UNKNOWN_VERSION;
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            stream.close();
            return string;
        }
        return UNKNOWN_VERSION;
    }

    public static void optionallyExitJVMIfExitCodeIsError(int exitCode) {
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static List<String> getOptionValuesAsStrings(@Nonnull String option, @Nonnull OptionSet parsedOptions) {
        Preconditions.checkNotNull((Object)option);
        Preconditions.checkNotNull((Object)parsedOptions);
        List objects = parsedOptions.valuesOf(option);
        ArrayList<String> values = new ArrayList<String>();
        if (objects != null) {
            for (Object arg : objects) {
                values.add(arg.toString());
            }
        }
        return values;
    }
}

