/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util;

import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineExecutor;
import com.adobe.granite.crx2oak.util.filesystem.DirectoryActivator;
import com.adobe.granite.crx2oak.util.filesystem.DirectoryElementsSwitcher;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemOps {
    public PipelineComponent createDirectoryActivator(File blessedDirectory, File candidateDirectory, String backupSuffix) throws IOException {
        return new DirectoryActivator(blessedDirectory, candidateDirectory, backupSuffix);
    }

    public PipelineComponent createUnsafeDirectoryCreator(File directoryToCreate) throws IOException {
        final File aCanonicalFile = directoryToCreate.getCanonicalFile();
        return new PipelineExecutor(){

            @Override
            public void run() {
                aCanonicalFile.mkdirs();
            }
        };
    }

    public PipelineComponent createSafeDirectoryCreator(File directoryToCreate) throws IOException {
        final File canonicalDirectoryToCreate = directoryToCreate.getCanonicalFile();
        return new InputAggregatingComponent(){
            private final String LOGGER_NAME = FilesystemOps.class.getCanonicalName() + ".SafeDirectoryCreatorProcessor";
            private final Logger log = LoggerFactory.getLogger((String)this.LOGGER_NAME);

            @Override
            protected PipeData preprocess(PipeData input) {
                if (!canonicalDirectoryToCreate.exists() || !canonicalDirectoryToCreate.isDirectory()) {
                    canonicalDirectoryToCreate.mkdirs();
                    if (!canonicalDirectoryToCreate.exists() || !canonicalDirectoryToCreate.isDirectory()) {
                        this.log.error("Cannot create directory: {}. Aborting processing", (Object)canonicalDirectoryToCreate);
                        return Pipeline.streamClosed();
                    }
                }
                return PipeData.EMPTY;
            }
        };
    }

    public PipelineComponent createDirectoryElementsSwitcher(File blessedDirectory, File candidateDirectory, String backupSuffix) throws IOException {
        return new DirectoryElementsSwitcher(blessedDirectory, candidateDirectory, backupSuffix);
    }
}

