/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util;

import com.adobe.granite.crx2oak.util.UncheckedIOException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesystemUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemUtils.class);

    private FilesystemUtils() {
    }

    @Nonnull
    public static String getCurrentTimestampFilenameSuffix() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return sdf.format(new Date());
    }

    @Nonnull
    public static String rewriteFileLines(@Nonnull String fileContent) {
        return Joiner.on((String)System.lineSeparator()).join(Splitter.onPattern((String)"\r?\n").split((CharSequence)fileContent));
    }

    public static void backup(File file, String backupSuffix) throws UncheckedIOException {
        try {
            if (file.exists()) {
                String backupFileName = file.getAbsolutePath() + backupSuffix + FilesystemUtils.getCurrentTimestampFilenameSuffix() + ".bak";
                FileUtils.copyFile((File)file, (File)new File(backupFileName));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean areTheSame(File file, String newContentOfFile) {
        return file.exists() && FilesystemUtils.areTheSameByCheckingChecksum(file, newContentOfFile);
    }

    private static boolean areTheSameByCheckingChecksum(File file, String newContentOfFile) {
        try {
            String existingContentChecksum = DigestUtils.sha512Hex((InputStream)new FileInputStream(file));
            String newContentChecksum = DigestUtils.sha512Hex((String)newContentOfFile);
            boolean equals = newContentChecksum.equals(existingContentChecksum);
            LOGGER.debug("The file {} with {} checksum and new content with {} checksum: are{} the same", new Object[]{file.getAbsolutePath(), existingContentChecksum, newContentChecksum, equals ? "" : "n't"});
            return equals;
        }
        catch (IOException e) {
            LOGGER.warn("Cannot compare existing file content with new content. Assuming that files are different.", (Throwable)e);
            return false;
        }
    }
}

