/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util;

import com.adobe.granite.crx2oak.util.JarFileReadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import org.apache.commons.codec.digest.DigestUtils;

class JarFile {
    private static final String HEADER_SPECIFICATION_VERSION = "Specification-Version";
    private static final String HEADER_IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String HEADER_MAIN_CLASS = "Main-Class";
    private String mainClass;
    private String version;
    private URL url;
    private File file;

    JarFile(String path) throws JarFileReadException {
        this.file = new File(path);
        if (!this.file.exists()) {
            throw new JarFileReadException("Cannot find file " + path);
        }
        java.util.jar.JarFile jarFile = null;
        try {
            jarFile = new java.util.jar.JarFile(this.file);
            Attributes manifestAttributes = jarFile.getManifest().getMainAttributes();
            this.mainClass = manifestAttributes.getValue(HEADER_MAIN_CLASS);
            if (this.mainClass == null) {
                throw new JarFileReadException("Expected to find a main class for JAR file " + path);
            }
            this.version = manifestAttributes.getValue(HEADER_SPECIFICATION_VERSION);
            if (this.version == null) {
                this.version = manifestAttributes.getValue(HEADER_IMPLEMENTATION_VERSION);
            }
            this.url = this.file.toURI().toURL();
        }
        catch (IOException e) {
            throw new JarFileReadException("Invalid jar file " + path, e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new JarFileReadException(e);
                }
            }
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHexadecimalChecksum() {
        FileInputStream fis = null;
        try {
            String hash;
            fis = new FileInputStream(this.file);
            String string = hash = DigestUtils.sha512Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            throw new JarFileReadException("Unable to calculate message digest for file " + this.file.getAbsolutePath(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                throw new JarFileReadException(e);
            }
        }
    }
}

