/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class MapDBMapFactory
extends MapFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final DB db = DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().make();

    public synchronized ConcurrentMap<String, Revision> create() {
        return this.db.createHashMap(String.valueOf(this.counter.incrementAndGet())).valueSerializer((Serializer)new RevisionSerializer()).make();
    }

    public ConcurrentMap<String, Revision> create(Comparator<String> comparator) {
        return this.db.createTreeMap(String.valueOf(this.counter.incrementAndGet())).valueSerializer((Serializer)new RevisionSerializer()).keySerializer((BTreeKeySerializer)new CustomKeySerializer(comparator)).counterEnable().make();
    }

    public void dispose() {
        this.db.close();
    }

    private static class CustomKeySerializer
    extends BTreeKeySerializer<String>
    implements Serializable {
        private static final long serialVersionUID = -95963379229842881L;
        private final Comparator<String> comparator;

        CustomKeySerializer(Comparator<String> comparator) {
            this.comparator = comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            BTreeKeySerializer.STRING.serialize(out, start, end, keys);
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            return BTreeKeySerializer.STRING.deserialize(in, start, end, size);
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }
    }

    private static class RevisionSerializer
    implements Serializer<Revision>,
    Serializable {
        private static final long serialVersionUID = 7858420083835005076L;
        private int size = 17;

        private RevisionSerializer() {
        }

        public void serialize(DataOutput o, Revision r) throws IOException {
            o.writeLong(r.getTimestamp());
            o.writeInt(r.getCounter());
            o.writeInt(r.getClusterId());
            o.writeBoolean(r.isBranch());
        }

        public Revision deserialize(DataInput i, int available) throws IOException {
            return new Revision(i.readLong(), i.readInt(), i.readInt(), i.readBoolean());
        }

        public int fixedSize() {
            return this.size;
        }
    }
}

