/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.util.filesystem;

import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.util.FilesystemUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryActivator
extends InputAggregatingComponent {
    private static final String LOGGER_PLACEHOLDER = "{}";
    private static final String STRING_FORMAT_PLACEHOLDER = "%s";
    private final Logger log = LoggerFactory.getLogger(DirectoryActivator.class);
    private final String ERROR_MSG = "Could not move directory: {} into: {}. You need to manually swap directories";
    private final File blessedDirectory;
    private final File candidateDirectory;
    private final File backupDirectory;

    public DirectoryActivator(@Nonnull File blessedDirectory, @Nonnull File candidateDirectory, @Nonnull String partialBackupSuffix) throws IOException {
        Preconditions.checkNotNull((Object)blessedDirectory);
        Preconditions.checkNotNull((Object)candidateDirectory);
        Preconditions.checkNotNull((Object)partialBackupSuffix);
        this.blessedDirectory = blessedDirectory.getCanonicalFile();
        this.candidateDirectory = candidateDirectory.getCanonicalFile();
        String fullSuffix = "-" + partialBackupSuffix + "backup-" + FilesystemUtils.getCurrentTimestampFilenameSuffix();
        this.backupDirectory = new File(this.blessedDirectory.getAbsolutePath() + fullSuffix);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        Optional<String> optWarning = this.blessedDirectory.exists() ? this.deactivatePreviouslyBlessedAndBlessACandidate() : this.blessACandidateDirectory();
        return optWarning.isPresent() ? PipeData.join(input, Topics.WARNINGS, (String)optWarning.get()).toPipe() : PipeData.EMPTY;
    }

    private Optional<String> deactivatePreviouslyBlessedAndBlessACandidate() {
        return this.blessedDirectory.renameTo(this.backupDirectory) ? this.blessACandidateDirectory() : this.announceMoveError(this.blessedDirectory, this.backupDirectory);
    }

    private Optional<String> blessACandidateDirectory() {
        return !this.candidateDirectory.renameTo(this.blessedDirectory) ? this.announceMoveError(this.candidateDirectory, this.blessedDirectory) : Optional.absent();
    }

    private Optional<String> announceMoveError(File fromDir, File toDir) {
        this.log.error("Could not move directory: {} into: {}. You need to manually swap directories", (Object)fromDir, (Object)toDir);
        return Optional.of((Object)String.format(this.getStringFormatMessage("Could not move directory: {} into: {}. You need to manually swap directories"), fromDir, toDir));
    }

    private String getStringFormatMessage(String loggerErrorMessage) {
        return loggerErrorMessage.replace(LOGGER_PLACEHOLDER, STRING_FORMAT_PLACEHOLDER);
    }
}

