/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RunModes {
    private final Collection<Group> groups;

    public RunModes(Collection<Group> groups) {
        this.groups = groups;
    }

    public Collection<Group> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public String toString() {
        return "RunModes{groups=" + this.groups + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunModes that = (RunModes)o;
        return Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public static class Group {
        private final List<String> modes;
        private final String selected;

        public Group(List<String> modes) {
            this(null, modes);
        }

        public Group(List<String> modes, String selected) {
            this(Objects.requireNonNull(selected), modes);
        }

        private Group(String selected, List<String> modes) {
            this.modes = Objects.requireNonNull(modes);
            this.selected = selected;
        }

        public List<String> getAvailableModes() {
            return ImmutableList.copyOf(this.modes);
        }

        public String getSelectedMode() {
            return this.selected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group that = (Group)o;
            return Objects.equals(this.modes, that.modes) && Objects.equals(this.selected, that.selected);
        }

        public int hashCode() {
            return Objects.hash(this.modes, this.selected);
        }

        public String toString() {
            return "Group{modes=" + this.modes + ", selected='" + this.selected + '\'' + '}';
        }
    }
}

