/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.settings.impl.RunModes;

public final class RunModesTransformer {
    private RunModes currentRunModes;

    private RunModesTransformer(RunModes runModes) {
        this.currentRunModes = Objects.requireNonNull(runModes);
    }

    public static RunModesTransformer transform(RunModes runModes) {
        return new RunModesTransformer(runModes);
    }

    public RunModesTransformer activate(String runMode) {
        this.transformRunModes(RunModesTransformer.getActivateFunction(runMode));
        return this;
    }

    private static Function<RunModes.Group, RunModes.Group> getActivateFunction(final String runMode) {
        return new Function<RunModes.Group, RunModes.Group>(){

            @Nullable
            public RunModes.Group apply(@Nullable RunModes.Group group) {
                assert (group != null);
                return group.getAvailableModes().contains(runMode) ? new RunModes.Group(group.getAvailableModes(), runMode) : group;
            }
        };
    }

    public RunModesTransformer deactivate(String runMode) {
        this.transformRunModes(RunModesTransformer.getDeactivateFunction(runMode));
        return this;
    }

    private static Function<RunModes.Group, RunModes.Group> getDeactivateFunction(final String runMode) {
        return new Function<RunModes.Group, RunModes.Group>(){

            @Nullable
            public RunModes.Group apply(@Nullable RunModes.Group group) {
                assert (group != null);
                return Objects.equals(group.getSelectedMode(), runMode) ? this.transformGroup(group) : group;
            }

            private RunModes.Group transformGroup(RunModes.Group group) {
                String firstNotEqual = this.getFirstNotEqual(runMode, group.getAvailableModes());
                return new RunModes.Group(group.getAvailableModes(), this.getElectedOrPreviousRunMode(group, firstNotEqual));
            }

            private String getElectedOrPreviousRunMode(RunModes.Group group, String firstNotEqual) {
                return firstNotEqual != null ? firstNotEqual : group.getSelectedMode();
            }

            private String getFirstNotEqual(final String runModeToDeactivate, List<String> availableModes) {
                return (String)Iterables.find(availableModes, (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String runMode) {
                        return !Objects.equals(runMode, runModeToDeactivate);
                    }
                });
            }
        };
    }

    private void transformRunModes(Function<RunModes.Group, RunModes.Group> transformFunction) {
        this.update(Iterables.transform(this.currentRunModes.getGroups(), transformFunction));
    }

    private void update(Iterable<RunModes.Group> newGroups) {
        this.currentRunModes = new RunModes(Lists.newArrayList(newGroups));
    }

    public RunModes toSlingRunMode() {
        return this.currentRunModes;
    }

    public RunModesTransformer install(String newRunMode, List<String> runModeGroupExamples) {
        Iterable<Pair<RunModes.Group, Integer>> rankedGroups = this.getGroupsWithRanksMatchingToExamples(runModeGroupExamples);
        Integer bestRankPosition = this.selectBestRank(rankedGroups);
        if (bestRankPosition < Integer.MAX_VALUE) {
            this.update(this.installRunModeForSelectedGroup(newRunMode, rankedGroups, bestRankPosition));
        }
        return this;
    }

    private Iterable<RunModes.Group> installRunModeForSelectedGroup(String newRunMode, Iterable<Pair<RunModes.Group, Integer>> rankedGroups, Integer rank) {
        return Iterables.transform(rankedGroups, RunModesTransformer.getSelectedInstallFunction(rank, newRunMode));
    }

    private Integer selectBestRank(Iterable<Pair<RunModes.Group, Integer>> rankedGroups) {
        return (Integer)Collections.min(Lists.newArrayList(this.getRanksOfGroups(rankedGroups)));
    }

    private Iterable<Pair<RunModes.Group, Integer>> getGroupsWithRanksMatchingToExamples(List<String> runModeGroupExamples) {
        return Iterables.transform(this.currentRunModes.getGroups(), RunModesTransformer.getGroupRankInstallFunction(runModeGroupExamples));
    }

    private Iterable<Integer> getRanksOfGroups(Iterable<Pair<RunModes.Group, Integer>> newGroupsWithRank) {
        return Iterables.transform(newGroupsWithRank, (Function)new Function<Pair<RunModes.Group, Integer>, Integer>(){

            @Nullable
            public Integer apply(@Nullable Pair<RunModes.Group, Integer> groupWithRank) {
                assert (groupWithRank != null);
                return (Integer)groupWithRank.getValue();
            }
        });
    }

    private static Function<Pair<RunModes.Group, Integer>, RunModes.Group> getSelectedInstallFunction(final Integer selectedRank, final String newRunMode) {
        return new Function<Pair<RunModes.Group, Integer>, RunModes.Group>(){

            @Nullable
            public RunModes.Group apply(@Nullable Pair<RunModes.Group, Integer> groupWithRank) {
                assert (groupWithRank != null);
                return Objects.equals(groupWithRank.getValue(), selectedRank) ? this.transformGroup((RunModes.Group)groupWithRank.getKey(), newRunMode) : (RunModes.Group)groupWithRank.getKey();
            }

            private RunModes.Group transformGroup(RunModes.Group group, String newRunMode2) {
                return new RunModes.Group(this.getNewRunModeGroup(group, newRunMode2), newRunMode2);
            }

            private List<String> getNewRunModeGroup(RunModes.Group group, String newRunMode2) {
                return group.getAvailableModes().contains(newRunMode2) ? group.getAvailableModes() : Lists.newArrayList((Iterable)Iterables.concat(group.getAvailableModes(), Collections.singletonList(newRunMode2)));
            }
        };
    }

    private static Function<RunModes.Group, Pair<RunModes.Group, Integer>> getGroupRankInstallFunction(final List<String> runModeGroupExamples) {
        return new Function<RunModes.Group, Pair<RunModes.Group, Integer>>(){

            @Nullable
            public Pair<RunModes.Group, Integer> apply(@Nullable RunModes.Group group) {
                assert (group != null);
                return Pair.of((Object)group, (Object)this.calculateRank(group));
            }

            private Integer calculateRank(@Nonnull RunModes.Group group) {
                return Collections.min(this.calculateDestinationGroupRank(runModeGroupExamples, this.getModeListOfGroup(group)));
            }

            private List<Integer> calculateDestinationGroupRank(final List<String> runModeGroupExamples2, List<String> currentModes) {
                return Lists.newArrayList((Iterable)Iterables.transform(currentModes, (Function)new Function<String, Integer>(){

                    @Nullable
                    public Integer apply(@Nullable String runModeToFind) {
                        return this.normalizeRank(runModeGroupExamples2.indexOf(runModeToFind));
                    }

                    private Integer normalizeRank(int index) {
                        return index < 0 ? Integer.MAX_VALUE : index;
                    }
                }));
            }

            private List<String> getModeListOfGroup(@Nonnull RunModes.Group group) {
                return Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(group.getSelectedMode()), group.getAvailableModes()));
            }
        };
    }
}

