/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.settings.impl.RunModes;
import org.apache.sling.settings.impl.SlingOptionsReadResult;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingOptionsFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingOptionsFileReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingOptionsReadResult readOptions(File file) {
        Optional<List<SlingSettingsServiceImpl.Options>> options;
        List optionsList = null;
        if (file.exists()) {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                Object object = ois.readObject();
                optionsList = object instanceof List ? (List)object : null;
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to read from options data file.", (Throwable)ioe);
                SlingOptionsReadResult slingOptionsReadResult = new SlingOptionsReadResult();
                return slingOptionsReadResult;
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("Unable to read from options data file.", (Throwable)cnfe);
                SlingOptionsReadResult slingOptionsReadResult = new SlingOptionsReadResult();
                return slingOptionsReadResult;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return (options = this.convertToOptionsList(optionsList)).isPresent() ? new SlingOptionsReadResult(this.getSlingRunModes((List)options.get())) : new SlingOptionsReadResult();
    }

    private RunModes getSlingRunModes(List<SlingSettingsServiceImpl.Options> list) {
        ArrayList<RunModes.Group> groups = new ArrayList<RunModes.Group>();
        for (SlingSettingsServiceImpl.Options options : list) {
            groups.add(this.getRunModeGroup(options));
        }
        return new RunModes(groups);
    }

    private RunModes.Group getRunModeGroup(SlingSettingsServiceImpl.Options options) {
        return options.selected == null ? new RunModes.Group(Arrays.asList(options.modes)) : new RunModes.Group(Arrays.asList(options.modes), options.selected);
    }

    private Optional<List<SlingSettingsServiceImpl.Options>> convertToOptionsList(List<?> aList) {
        return aList != null ? this.convertToOptionsListNotNull(aList) : Optional.absent();
    }

    private Optional<List<SlingSettingsServiceImpl.Options>> convertToOptionsListNotNull(List<?> aList) {
        ArrayList<SlingSettingsServiceImpl.Options> optionsList = new ArrayList<SlingSettingsServiceImpl.Options>();
        for (Object object : aList) {
            if (object instanceof SlingSettingsServiceImpl.Options) {
                optionsList.add((SlingSettingsServiceImpl.Options)object);
                continue;
            }
            return Optional.absent();
        }
        return Optional.of(optionsList);
    }
}

