/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sling.settings.impl.RunModes;
import org.apache.sling.settings.impl.SlingOptionsFileReader;
import org.apache.sling.settings.impl.SlingOptionsReadResult;
import org.apache.sling.settings.impl.SlingOptionsWriteException;
import org.apache.sling.settings.impl.SlingOptionsWriteVerifyException;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;

public class SlingOptionsFileWriter {
    private final SlingOptionsFileReader reader;

    public SlingOptionsFileWriter(SlingOptionsFileReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    public void writeOptions(RunModes runModes, File file) throws SlingOptionsWriteException {
        Objects.requireNonNull(runModes);
        Objects.requireNonNull(file);
        List<SlingSettingsServiceImpl.Options> slingInternalOptions = this.getSlingInternalOptions(runModes);
        this.writeOptions(slingInternalOptions, file);
        this.verifyWrite(runModes, file);
    }

    private void verifyWrite(RunModes runModes, File file) {
        SlingOptionsReadResult slingOptionsReadResult = this.reader.readOptions(file);
        if (!slingOptionsReadResult.isSuccessful()) {
            throw new SlingOptionsWriteVerifyException(String.format("Could not verify write to: %s", file.getAbsolutePath()));
        }
        RunModes actualRunModes = slingOptionsReadResult.getRunModes();
        if (!actualRunModes.equals(runModes)) {
            throw new IllegalStateException(String.format("The contents of run modes before write (%s) and after file (%s) differs.", runModes, actualRunModes));
        }
    }

    private void writeOptions(List<SlingSettingsServiceImpl.Options> optionsList, File file) throws SlingOptionsWriteException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(optionsList);
            this.closeQuietly(fos, oos);
        }
        catch (IOException ioe) {
            try {
                throw new SlingOptionsWriteException("Unable to write to options data file.", ioe);
            }
            catch (Throwable throwable) {
                this.closeQuietly(fos, oos);
                throw throwable;
            }
        }
    }

    private void closeQuietly(FileOutputStream fos, ObjectOutputStream oos) {
        if (oos != null) {
            try {
                oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private List<SlingSettingsServiceImpl.Options> getSlingInternalOptions(RunModes runModes) {
        ArrayList<SlingSettingsServiceImpl.Options> optionsList = new ArrayList<SlingSettingsServiceImpl.Options>();
        for (RunModes.Group group : runModes.getGroups()) {
            SlingSettingsServiceImpl.Options options = new SlingSettingsServiceImpl.Options();
            options.modes = group.getAvailableModes().toArray(new String[0]);
            options.selected = group.getSelectedMode();
            optionsList.add(options);
        }
        return optionsList;
    }
}

