/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.util.ThreadLocalData;
import gnu.crypto.hash.RipeMD160;
import java.util.Arrays;

public final class Key {
    public final String namespace;
    public final String setName;
    public final byte[] digest;
    public final Object userKey;

    public Key(String namespace, String setName, String key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        this.digest = Key.computeDigest(setName, new Value.StringValue(key));
    }

    public Key(String namespace, String setName, byte[] key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        this.digest = Key.computeDigest(setName, new Value.BytesValue(key));
    }

    public Key(String namespace, String setName, byte[] key, int offset, int length) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        Value.ByteSegmentValue value = new Value.ByteSegmentValue(key, offset, length);
        this.userKey = value;
        this.digest = Key.computeDigest(setName, value);
    }

    public Key(String namespace, String setName, int key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        this.digest = Key.computeDigest(setName, new Value.LongValue(key));
    }

    public Key(String namespace, String setName, long key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        this.digest = Key.computeDigest(setName, new Value.LongValue(key));
    }

    public Key(String namespace, String setName, Value key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        this.digest = Key.computeDigest(setName, key);
    }

    public Key(String namespace, byte[] digest, String setName) {
        this.namespace = namespace;
        this.digest = digest;
        this.setName = setName;
        this.userKey = null;
    }

    public Key(String namespace, byte[] digest) {
        this.namespace = namespace;
        this.digest = digest;
        this.setName = null;
        this.userKey = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.digest);
        return 31 * result + this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        Key other = (Key)obj;
        if (!Arrays.equals(this.digest, other.digest)) {
            return false;
        }
        return this.namespace.equals(other.namespace);
    }

    public static byte[] computeDigest(String setName, Value key) throws AerospikeException {
        int keyType = key.getType();
        if (keyType == 0) {
            throw new AerospikeException(4, "Invalid key: null");
        }
        byte[] buffer = ThreadLocalData.getBuffer();
        int setLength = Buffer.stringToUtf8(setName, buffer, 0);
        buffer[setLength] = (byte)keyType;
        int keyLength = key.write(buffer, setLength + 1);
        RipeMD160 hash = new RipeMD160();
        hash.update(buffer, 0, setLength);
        hash.update(buffer, setLength, keyLength + 1);
        return hash.digest();
    }
}

