/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.policy.Policy;
import java.nio.ByteBuffer;

public final class AsyncExists
extends AsyncSingleCommand {
    private final Policy policy;
    private final ExistsListener listener;
    private boolean exists;

    public AsyncExists(AsyncCluster cluster, Policy policy, ExistsListener listener, Key key) {
        super(cluster, key);
        this.policy = policy == null ? new Policy() : policy;
        this.listener = listener;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setExists(this.key);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode == 0) {
            this.exists = true;
        } else if (resultCode == 2) {
            this.exists = false;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.exists);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

