/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;
import java.nio.ByteBuffer;

public class AsyncReadHeader
extends AsyncSingleCommand {
    private final Policy policy;
    private final RecordListener listener;
    private Record record;

    public AsyncReadHeader(AsyncCluster cluster, Policy policy, RecordListener listener, Key key) {
        super(cluster, key);
        this.policy = policy == null ? new Policy() : policy;
        this.listener = listener;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setReadHeader(this.key);
    }

    @Override
    protected final void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode == 0) {
            int generation = byteBuffer.getInt(6);
            int expiration = byteBuffer.getInt(10);
            this.record = new Record(null, null, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected final void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected final void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

