/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.PartitionTokenizerNew;
import com.aerospike.client.cluster.PartitionTokenizerOld;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable {
    private volatile Host[] seeds;
    private final HashMap<Host, Node> aliases;
    private volatile Node[] nodes;
    private volatile HashMap<String, AtomicReferenceArray<Node>> partitionWriteMap;
    private final AtomicInteger nodeIndex;
    private final ExecutorService threadPool;
    protected final int connectionQueueSize;
    private final int connectionTimeout;
    protected final int maxSocketIdle;
    private Thread tendThread;
    private volatile boolean tendValid;
    private final boolean sharedThreadPool;

    public Cluster(ClientPolicy policy, Host[] hosts) throws AerospikeException {
        this.seeds = hosts;
        this.connectionQueueSize = policy.maxThreads + 1;
        this.connectionTimeout = policy.timeout;
        this.maxSocketIdle = policy.maxSocketIdle;
        this.threadPool = policy.threadPool == null ? Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public final Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        }) : policy.threadPool;
        this.sharedThreadPool = policy.sharedThreadPool;
        this.aliases = new HashMap();
        this.nodes = new Node[0];
        this.partitionWriteMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
    }

    public void initTendThread() {
        this.waitTillStabilized();
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + host);
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (this.findSeed(host)) continue;
            seedsToAdd.add(host);
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + host);
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized() {
        long limit = System.currentTimeMillis() + (long)this.connectionTimeout;
        int count = -1;
        do {
            this.tend();
            if (count == this.nodes.length) {
                return;
            }
            Util.sleep(1L);
            count = this.nodes.length;
        } while (System.currentTimeMillis() < limit);
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend();
                }
                catch (Exception e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(1000L);
        }
    }

    private final void tend() {
        if (this.nodes.length == 0) {
            this.seedNodes();
        }
        for (Node node : this.nodes) {
            node.referenceCount = 0;
            node.responded = false;
        }
        ArrayList<Host> friendList = new ArrayList<Host>();
        int refreshCount = 0;
        for (Node node : this.nodes) {
            try {
                if (!node.isActive()) continue;
                node.refresh(friendList);
                ++refreshCount;
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) continue;
                Log.debug("Node " + node + " refresh failed: " + Util.getErrorMessage(e));
            }
        }
        ArrayList<Node> addList = this.findNodesToAdd(friendList);
        ArrayList<Node> removeList = this.findNodesToRemove(refreshCount);
        if (removeList.size() > 0) {
            this.removeNodes(removeList);
        }
        if (addList.size() > 0) {
            this.addNodes(addList);
        }
    }

    protected final Node findAlias(Host alias) {
        return this.aliases.get(alias);
    }

    protected final void updatePartitions(Connection conn, Node node) throws AerospikeException {
        HashMap<String, AtomicReferenceArray<Node>> map;
        if (node.useNewInfo) {
            PartitionTokenizerNew tokens = new PartitionTokenizerNew(conn);
            map = tokens.updatePartition(this.partitionWriteMap, node);
        } else {
            PartitionTokenizerOld tokens = new PartitionTokenizerOld(conn);
            map = tokens.updatePartition(this.partitionWriteMap, node);
        }
        if (map != null) {
            this.partitionWriteMap = map;
        }
    }

    private final void seedNodes() {
        Host[] seedArray = this.seeds;
        ArrayList<Node> list = new ArrayList<Node>();
        for (Host seed : seedArray) {
            try {
                NodeValidator seedNodeValidator = new NodeValidator(seed, this.connectionTimeout);
                for (Host alias : seedNodeValidator.aliases) {
                    NodeValidator nv = alias.equals(seed) ? seedNodeValidator : new NodeValidator(alias, this.connectionTimeout);
                    if (Cluster.findNodeName(list, nv.name)) continue;
                    Node node = this.createNode(nv);
                    this.addAliases(node);
                    list.add(node);
                }
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) continue;
                Log.debug("Seed " + seed + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (list.size() > 0) {
            this.addNodesCopy(list);
        }
    }

    private static final boolean findNodeName(ArrayList<Node> list, String name) {
        for (Node node : list) {
            if (!node.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private final ArrayList<Node> findNodesToAdd(List<Host> hosts) {
        ArrayList<Node> list = new ArrayList<Node>(hosts.size());
        for (Host host : hosts) {
            try {
                NodeValidator nv = new NodeValidator(host, this.connectionTimeout);
                Node node = this.findNode(nv.name);
                if (node != null) {
                    ++node.referenceCount;
                    node.addAlias(host);
                    this.aliases.put(host, node);
                    continue;
                }
                node = this.createNode(nv);
                list.add(node);
            }
            catch (Exception e) {
                if (!Log.warnEnabled()) continue;
                Log.warn("Add node " + host + " failed: " + Util.getErrorMessage(e));
            }
        }
        return list;
    }

    protected Node createNode(NodeValidator nv) {
        return new Node(this, nv);
    }

    private final ArrayList<Node> findNodesToRemove(int refreshCount) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        block4: for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeList.add(node);
                continue;
            }
            switch (this.nodes.length) {
                case 1: {
                    if (!node.isUnhealthy()) continue block4;
                    removeList.add(node);
                    continue block4;
                }
                case 2: {
                    if (refreshCount != 1 || node.referenceCount != 0 || node.responded) continue block4;
                    removeList.add(node);
                    continue block4;
                }
                default: {
                    if (refreshCount < 2 || node.referenceCount != 0) continue block4;
                    if (node.responded) {
                        if (this.findNodeInPartitionMap(node)) continue block4;
                        removeList.add(node);
                        continue block4;
                    }
                    removeList.add(node);
                }
            }
        }
        return removeList;
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (AtomicReferenceArray<Node> nodeArray : this.partitionWriteMap.values()) {
            int max = nodeArray.length();
            for (int i = 0; i < max; ++i) {
                Node node = nodeArray.get(i);
                if (node != filter) continue;
                return true;
            }
        }
        return false;
    }

    private final void addNodes(List<Node> nodesToAdd) {
        for (Node node : nodesToAdd) {
            this.addAliases(node);
        }
        this.addNodesCopy(nodesToAdd);
    }

    private final void addAliases(Node node) {
        for (Host alias : node.getAliases()) {
            this.aliases.put(alias, node);
        }
    }

    private final void addNodesCopy(List<Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd) {
            if (Log.infoEnabled()) {
                Log.info("Add node " + node);
            }
            nodeArray[count++] = node;
        }
        this.nodes = nodeArray;
    }

    private final void removeNodes(List<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            for (Host alias : node.getAliases()) {
                this.aliases.remove(alias);
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(List<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (Cluster.findNode(node, nodesToRemove)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + node);
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.nodes = nodeArray;
    }

    private static final boolean findNode(Node search, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!node.equals(search)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        return nodeArray.length > 0 && this.tendValid;
    }

    public final Node getNode(Partition partition) throws AerospikeException.InvalidNode {
        Node node;
        HashMap<String, AtomicReferenceArray<Node>> map = this.partitionWriteMap;
        AtomicReferenceArray<Node> nodeArray = map.get(partition.namespace);
        if (nodeArray != null && (node = nodeArray.get(partition.partitionId)) != null && node.isActive()) {
            return node;
        }
        return this.getRandomNode();
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            Node node = nodeArray[index2];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode();
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode();
        }
        return node;
    }

    private final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final int getMaxSocketIdle() {
        return this.maxSocketIdle;
    }

    public void close() {
        Node[] nodeArray;
        if (!this.sharedThreadPool) {
            this.threadPool.shutdown();
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        for (Node node : nodeArray = this.nodes) {
            node.close();
        }
    }
}

