/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.Statement;
import java.util.concurrent.ExecutorService;

public abstract class QueryExecutor {
    protected final QueryPolicy policy;
    protected final Statement statement;
    private final Node[] nodes;
    protected final ExecutorService threadPool;
    private final QueryThread[] threads;
    protected volatile Exception exception;
    private int nextThread;

    public QueryExecutor(Cluster cluster, QueryPolicy policy, Statement statement) throws AerospikeException {
        this.policy = policy;
        this.policy.maxRetries = 0;
        this.statement = statement;
        this.nodes = cluster.getNodes();
        if (this.nodes.length == 0) {
            throw new AerospikeException(11, "Query failed because cluster is empty.");
        }
        this.threadPool = cluster.getThreadPool();
        this.threads = new QueryThread[this.nodes.length];
    }

    protected final void startThreads() {
        for (int i = 0; i < this.nodes.length; ++i) {
            QueryCommand command = this.createCommand(this.nodes[i]);
            this.threads[i] = new QueryThread(command);
        }
        int max = this.nextThread = this.policy.maxConcurrentNodes == 0 || this.policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : this.policy.maxConcurrentNodes;
        for (int i = 0; i < max; ++i) {
            this.threadPool.execute(this.threads[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void threadCompleted() {
        int index2 = -1;
        QueryThread[] queryThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.nextThread < this.threads.length) {
                index2 = this.nextThread++;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (index2 >= 0) {
                this.threadPool.execute(this.threads[index2]);
            } else {
                for (QueryThread thread : this.threads) {
                    if (thread.complete) continue;
                    return;
                }
                this.sendCompleted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopThreads(Exception cause) {
        QueryThread[] queryThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.exception != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.exception = cause;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (QueryThread thread : this.threads) {
                try {
                    thread.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.sendCompleted();
            return;
        }
    }

    protected final void checkForException() throws AerospikeException {
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    protected abstract QueryCommand createCommand(Node var1);

    protected abstract void sendCompleted();

    private final class QueryThread
    implements Runnable {
        private final QueryCommand command;
        private Thread thread;
        private volatile boolean complete;

        public QueryThread(QueryCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                QueryExecutor.this.stopThreads(e);
            }
            this.complete = true;
            if (QueryExecutor.this.exception == null) {
                QueryExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

