/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.SelectorManager;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.atomic.AtomicInteger;

public final class SelectorManagers {
    private final SelectorManager[] managers;
    private final AtomicInteger current = new AtomicInteger();

    public SelectorManagers(AsyncClientPolicy policy) throws AerospikeException {
        this.managers = new SelectorManager[policy.asyncSelectorThreads];
        SelectorProvider provider = SelectorProvider.provider();
        for (int i = 0; i < policy.asyncSelectorThreads; ++i) {
            try {
                this.managers[i] = new SelectorManager(policy, provider);
                continue;
            }
            catch (IOException ioe) {
                for (int j = 0; j < i; ++j) {
                    this.managers[j].close();
                }
                throw new AerospikeException("Failed to construct event manager: " + Util.getErrorMessage(ioe));
            }
        }
        int count = 0;
        for (SelectorManager manager : this.managers) {
            manager.setName("selector" + count);
            manager.setDaemon(true);
            manager.start();
            ++count;
        }
    }

    public SelectorManager next() {
        return this.managers[Math.abs(this.current.getAndIncrement() % this.managers.length)];
    }

    public void close() {
        for (SelectorManager manager : this.managers) {
            manager.close();
        }
    }
}

