/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.NodeValidator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class Node {
    public static final int PARTITIONS = 4096;
    private static final int FULL_HEALTH = 100;
    protected final Cluster cluster;
    private final String name;
    private final Host host;
    private Host[] aliases;
    protected final InetSocketAddress address;
    private final ArrayBlockingQueue<Connection> connectionQueue;
    private final AtomicInteger health;
    private int partitionGeneration;
    protected int referenceCount;
    protected boolean responded;
    protected final boolean useNewInfo;
    protected volatile boolean active;

    public Node(Cluster cluster, NodeValidator nv) {
        this.cluster = cluster;
        this.name = nv.name;
        this.aliases = nv.aliases;
        this.address = nv.address;
        this.useNewInfo = nv.useNewInfo;
        this.host = this.aliases[0];
        this.connectionQueue = new ArrayBlockingQueue(cluster.connectionQueueSize);
        this.health = new AtomicInteger(100);
        this.partitionGeneration = -1;
        this.active = true;
    }

    public final void refresh(List<Host> friends) throws Exception {
        Connection conn = this.getConnection(1000);
        try {
            HashMap<String, String> infoMap = Info.request(conn, "node", "partition-generation", "services");
            this.verifyNodeName(infoMap);
            this.restoreHealth();
            this.responded = true;
            this.addFriends(infoMap, friends);
            this.updatePartitions(conn, infoMap);
            this.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            this.decreaseHealth();
            throw e;
        }
    }

    private final void verifyNodeName(HashMap<String, String> infoMap) throws AerospikeException {
        String infoName = infoMap.get("node");
        if (infoName == null || infoName.length() == 0) {
            this.decreaseHealth();
            throw new AerospikeException.Parse("Node name is empty");
        }
        if (!this.name.equals(infoName)) {
            this.active = false;
            throw new AerospikeException("Node name has changed. Old=" + this.name + " New=" + infoName);
        }
    }

    private final void addFriends(HashMap<String, String> infoMap, List<Host> friends) throws AerospikeException {
        String[] friendNames;
        String friendString = infoMap.get("services");
        if (friendString == null || friendString.length() == 0) {
            return;
        }
        for (String friend : friendNames = friendString.split(";")) {
            int port;
            String[] friendInfo = friend.split(":");
            String host = friendInfo[0];
            Host alias = new Host(host, port = Integer.parseInt(friendInfo[1]));
            Node node = this.cluster.findAlias(alias);
            if (node != null) {
                ++node.referenceCount;
                continue;
            }
            if (Node.findAlias(friends, alias)) continue;
            friends.add(alias);
        }
    }

    private static final boolean findAlias(List<Host> friends, Host alias) {
        for (Host host : friends) {
            if (!host.equals(alias)) continue;
            return true;
        }
        return false;
    }

    private final void updatePartitions(Connection conn, HashMap<String, String> infoMap) throws AerospikeException, IOException {
        String genString = infoMap.get("partition-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("partition-generation is empty");
        }
        int generation = Integer.parseInt(genString);
        if (this.partitionGeneration != generation) {
            if (Log.debugEnabled()) {
                Log.debug("Node " + this + " partition generation " + generation + " changed.");
            }
            this.cluster.updatePartitions(conn, this);
            this.partitionGeneration = generation;
        }
    }

    public final Connection getConnection(int timeoutMillis) throws AerospikeException.Connection {
        Connection conn;
        while ((conn = this.connectionQueue.poll()) != null) {
            if (conn.isValid()) {
                try {
                    conn.setTimeout(timeoutMillis);
                    return conn;
                }
                catch (Exception e) {
                    conn.close();
                    throw new AerospikeException.Connection(e);
                }
            }
            conn.close();
        }
        return new Connection(this.address, timeoutMillis, this.cluster.maxSocketIdle);
    }

    public final void putConnection(Connection conn) {
        if (!this.active || !this.connectionQueue.offer(conn)) {
            conn.close();
        }
    }

    public final void restoreHealth() {
        this.health.set(100);
    }

    public final void decreaseHealth() {
        this.health.decrementAndGet();
    }

    public final boolean isUnhealthy() {
        return this.health.get() <= 0;
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getName() {
        return this.name;
    }

    public final Host[] getAliases() {
        return this.aliases;
    }

    public final void addAlias(Host aliasToAdd) {
        Host[] tmpAliases = new Host[this.aliases.length + 1];
        int count = 0;
        for (Host host : this.aliases) {
            tmpAliases[count++] = host;
        }
        tmpAliases[count] = aliasToAdd;
        this.aliases = tmpAliases;
    }

    public final void close() {
        this.active = false;
        this.closeConnections();
    }

    public final String toString() {
        return this.name + ' ' + this.host;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            this.closeConnections();
        }
        finally {
            super.finalize();
        }
    }

    protected void closeConnections() {
        Connection conn;
        while ((conn = this.connectionQueue.poll()) != null) {
            conn.close();
        }
    }
}

