/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import gnu.crypto.util.Base64;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionTokenizerNew {
    private static final String ReplicasName = "replicas-master";
    protected final StringBuilder sb;
    protected final byte[] buffer;
    protected int length;
    protected int offset;

    public PartitionTokenizerNew(Connection conn) throws AerospikeException {
        Info info = new Info(conn, ReplicasName);
        this.length = info.getLength();
        if (this.length == 0) {
            throw new AerospikeException.Parse("replicas-master is empty");
        }
        this.buffer = info.getBuffer();
        this.offset = ReplicasName.length() + 1;
        this.sb = new StringBuilder(32);
    }

    public HashMap<String, AtomicReferenceArray<Node>> updatePartition(HashMap<String, AtomicReferenceArray<Node>> map, Node node) throws AerospikeException {
        int begin = this.offset;
        boolean copied = false;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                if (this.offset == begin) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                }
                AtomicReferenceArray<Node> nodeArray = map.get(namespace);
                if (nodeArray == null) {
                    if (!copied) {
                        map = new HashMap<String, AtomicReferenceArray<Node>>(map);
                        copied = true;
                    }
                    nodeArray = new AtomicReferenceArray<Node>(new Node[4096]);
                    map.put(namespace, nodeArray);
                }
                int bitMapLength = this.offset - begin;
                byte[] restoreBuffer = Base64.decode((byte[])this.buffer, (int)begin, (int)bitMapLength);
                for (int i = 0; i < 4096; ++i) {
                    if ((restoreBuffer[i >> 3] & 128 >> (i & 7)) == 0) continue;
                    nodeArray.lazySet(i, node);
                }
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
        return copied ? map : null;
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

