/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchCommandExists;
import com.aerospike.client.command.BatchCommandGet;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class BatchExecutor {
    private final ArrayList<BatchThread> threads;
    private volatile Exception exception;
    private boolean completed;

    public BatchExecutor(Cluster cluster, Policy policy, Key[] keys2, boolean[] existsArray, Record[] records, HashSet<String> binNames, int readAttr) throws AerospikeException {
        List<BatchNode> batchNodes = BatchNode.generateList(cluster, keys2);
        HashMap<Key, BatchItem> keyMap = BatchItem.generateMap(keys2);
        this.threads = new ArrayList(batchNodes.size() * 2);
        MultiCommand command = null;
        for (BatchNode batchNode : batchNodes) {
            for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                command = records != null ? new BatchCommandGet(batchNode.node, batchNamespace, policy, keyMap, binNames, records, readAttr) : new BatchCommandExists(batchNode.node, batchNamespace, policy, keyMap, existsArray);
                this.threads.add(new BatchThread(command));
            }
        }
        ExecutorService threadPool = cluster.getThreadPool();
        for (BatchThread thread : this.threads) {
            threadPool.execute(thread);
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        for (BatchThread thread : this.threads) {
            if (thread.complete) continue;
            return;
        }
        this.notifyCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ArrayList<BatchThread> arrayList = this.threads;
        synchronized (arrayList) {
            if (this.exception != null) {
                return;
            }
            this.exception = cause;
        }
        for (BatchThread thread : this.threads) {
            try {
                thread.stop();
            }
            catch (Exception e) {}
        }
        this.notifyCompleted();
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class BatchThread
    implements Runnable {
        private MultiCommand command;
        private Thread thread;
        private volatile boolean complete;

        public BatchThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                BatchExecutor.this.stopThreads(e);
            }
            this.complete = true;
            if (BatchExecutor.this.exception == null) {
                BatchExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

