/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import java.util.ArrayList;
import java.util.List;

public final class BatchNode {
    public final Node node;
    public final List<BatchNamespace> batchNamespaces;
    public final int keyCapacity;

    public static List<BatchNode> generateList(Cluster cluster, Key[] keys2) throws AerospikeException {
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        int nodeCount = nodes.length;
        int keysPerNode = keys2.length / nodeCount + 10;
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodeCount + 1);
        for (int i = 0; i < keys2.length; ++i) {
            Key key = keys2[i];
            Partition partition = new Partition(key);
            Node node = cluster.getNode(partition);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, key));
                continue;
            }
            batchNode.addKey(key);
        }
        return batchNodes;
    }

    public BatchNode(Node node, int keyCapacity, Key key) {
        this.node = node;
        this.keyCapacity = keyCapacity;
        this.batchNamespaces = new ArrayList<BatchNamespace>(4);
        this.batchNamespaces.add(new BatchNamespace(key.namespace, keyCapacity, key));
    }

    public void addKey(Key key) {
        BatchNamespace batchNamespace = this.findNamespace(key.namespace);
        if (batchNamespace == null) {
            this.batchNamespaces.add(new BatchNamespace(key.namespace, this.keyCapacity, key));
        } else {
            batchNamespace.keys.add(key);
        }
    }

    private BatchNamespace findNamespace(String ns) {
        for (BatchNamespace batchNamespace : this.batchNamespaces) {
            if (batchNamespace.namespace != ns && !batchNamespace.namespace.equals(ns)) continue;
            return batchNamespace;
        }
        return null;
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }

    public static final class BatchNamespace {
        public final String namespace;
        public final ArrayList<Key> keys;

        public BatchNamespace(String namespace, int capacity, Key key) {
            this.namespace = namespace;
            this.keys = new ArrayList(capacity);
            this.keys.add(key);
        }
    }
}

