/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.policy.ScanPolicy;
import java.util.concurrent.ExecutorService;

public final class ScanExecutor {
    private final ExecutorService threadPool;
    private final ScanThread[] threads;
    private volatile Exception exception;
    private int nextThread;
    private boolean completed;

    public ScanExecutor(Cluster cluster, Node[] nodes, ScanPolicy policy, String namespace, String setName, ScanCallback callback, String[] binNames) {
        this.threadPool = cluster.getThreadPool();
        this.threads = new ScanThread[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ScanCommand command = new ScanCommand(nodes[i], policy, namespace, setName, callback, binNames);
            this.threads[i] = new ScanThread(command);
        }
        this.nextThread = policy.maxConcurrentNodes == 0 || policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : policy.maxConcurrentNodes;
    }

    public void scanParallel() throws AerospikeException {
        int max = this.nextThread;
        for (int i = 0; i < max; ++i) {
            this.threadPool.execute(this.threads[i]);
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadCompleted() {
        int index2 = -1;
        ScanThread[] scanThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.nextThread < this.threads.length) {
                index2 = this.nextThread++;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (index2 >= 0) {
                this.threadPool.execute(this.threads[index2]);
            } else {
                for (ScanThread thread : this.threads) {
                    if (thread.complete) continue;
                    return;
                }
                this.notifyCompleted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ScanThread[] scanThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.exception != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.exception = cause;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (ScanThread thread : this.threads) {
                try {
                    thread.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.notifyCompleted();
            return;
        }
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class ScanThread
    implements Runnable {
        private final ScanCommand command;
        private Thread thread;
        private volatile boolean complete;

        public ScanThread(ScanCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                ScanExecutor.this.stopThreads(e);
            }
            this.complete = true;
            if (ScanExecutor.this.exception == null) {
                ScanExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

