/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.task.Task;

public final class IndexTask
extends Task {
    private final String namespace;
    private final String indexName;

    public IndexTask(Cluster cluster, String namespace, String indexName) {
        super(cluster, false);
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public IndexTask() {
        super(null, true);
        this.namespace = null;
        this.indexName = null;
    }

    @Override
    public boolean isDone() throws AerospikeException {
        String command = "sindex/" + this.namespace + '/' + this.indexName;
        Node[] nodes = this.cluster.getNodes();
        boolean complete = false;
        for (Node node : nodes) {
            try {
                int end;
                String response = Info.request(node, command);
                String find = "load_pct=";
                int index2 = response.indexOf(find);
                if (index2 < 0) {
                    complete = true;
                    continue;
                }
                int begin = index2 + find.length();
                String str = response.substring(begin, end = response.indexOf(59, begin));
                int pct = Integer.parseInt(str);
                if (pct >= 0 && pct < 100) {
                    return false;
                }
                complete = true;
            }
            catch (Exception e) {
                complete = true;
            }
        }
        return complete;
    }
}

