/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.command.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Unpacker<T> {
    private final byte[] buffer;
    private int offset;
    private final int length;

    public Unpacker(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public final T unpackList() throws AerospikeException {
        if (this.length <= 0) {
            return (T)this.getList(new ArrayList(0));
        }
        try {
            int count;
            int type = this.buffer[this.offset++] & 0xFF;
            if ((type & 0xF0) == 144) {
                count = type & 0xF;
            } else if (type == 220) {
                count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
            } else if (type == 221) {
                count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
            } else {
                return (T)this.getList(new ArrayList(0));
            }
            return this.unpackList(count);
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    private T unpackList(int count) throws IOException, ClassNotFoundException {
        ArrayList<T> out = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            out.add(this.unpackObject());
        }
        return (T)this.getList(out);
    }

    public final T unpackMap() throws AerospikeException {
        if (this.length <= 0) {
            return (T)this.getMap(new HashMap(0));
        }
        try {
            int count;
            int type = this.buffer[this.offset++] & 0xFF;
            if ((type & 0xF0) == 128) {
                count = type & 0xF;
            } else if (type == 222) {
                count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
            } else if (type == 223) {
                count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
            } else {
                return (T)this.getMap(new HashMap(0));
            }
            return this.unpackMap(count);
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    private T unpackMap(int count) throws IOException, ClassNotFoundException {
        HashMap<T, T> out = new HashMap<T, T>();
        for (int i = 0; i < count; ++i) {
            T key = this.unpackObject();
            T val = this.unpackObject();
            out.put(key, val);
        }
        return (T)this.getMap(out);
    }

    private T unpackBlob(int count) throws IOException, ClassNotFoundException {
        T val;
        int type = this.buffer[this.offset++] & 0xFF;
        --count;
        switch (type) {
            case 3: {
                val = this.getString(Buffer.utf8ToString(this.buffer, this.offset, count));
                break;
            }
            case 7: {
                ByteArrayInputStream bastream = new ByteArrayInputStream(this.buffer, this.offset, count);
                ObjectInputStream oistream = new ObjectInputStream(bastream);
                val = this.getJavaBlob(oistream.readObject());
                break;
            }
            default: {
                val = this.getBlob(Arrays.copyOfRange(this.buffer, this.offset, this.offset + count));
            }
        }
        this.offset += count;
        return val;
    }

    private T unpackObject() throws IOException, ClassNotFoundException {
        int type = this.buffer[this.offset++] & 0xFF;
        switch (type) {
            case 192: {
                return null;
            }
            case 195: {
                return this.getBoolean(true);
            }
            case 194: {
                return this.getBoolean(false);
            }
            case 202: {
                float val = Float.intBitsToFloat(Buffer.bytesToInt(this.buffer, this.offset));
                this.offset += 4;
                return this.getDouble(val);
            }
            case 203: {
                double val = Double.longBitsToDouble(Buffer.bytesToLong(this.buffer, this.offset));
                this.offset += 8;
                return this.getDouble(val);
            }
            case 204: {
                return this.getLong(this.buffer[this.offset++] & 0xFF);
            }
            case 205: {
                int val = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.getLong(val);
            }
            case 206: {
                int val = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.getLong(val);
            }
            case 207: {
                long val = Buffer.bytesToLong(this.buffer, this.offset);
                this.offset += 8;
                return this.getLong(val);
            }
            case 208: {
                return this.getLong(this.buffer[this.offset++]);
            }
            case 209: {
                int val = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.getLong(val);
            }
            case 210: {
                int val = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.getLong(val);
            }
            case 211: {
                long val = Buffer.bytesToLong(this.buffer, this.offset);
                this.offset += 8;
                return this.getLong(val);
            }
            case 218: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackBlob(count);
            }
            case 219: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackBlob(count);
            }
            case 220: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackList(count);
            }
            case 221: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackList(count);
            }
            case 222: {
                int count = Buffer.bytesToShort(this.buffer, this.offset);
                this.offset += 2;
                return this.unpackMap(count);
            }
            case 223: {
                int count = Buffer.bytesToInt(this.buffer, this.offset);
                this.offset += 4;
                return this.unpackMap(count);
            }
        }
        if ((type & 0xE0) == 160) {
            return this.unpackBlob(type & 0x1F);
        }
        if ((type & 0xF0) == 128) {
            return this.unpackMap(type & 0xF);
        }
        if ((type & 0xF0) == 144) {
            return this.unpackList(type & 0xF);
        }
        if (type < 128) {
            return this.getLong(type);
        }
        if (type >= 224) {
            return this.getLong(type - 224 - 32);
        }
        throw new IOException("Unknown unpack type: " + type);
    }

    protected abstract T getMap(Map<T, T> var1);

    protected abstract T getList(List<T> var1);

    protected abstract T getJavaBlob(Object var1);

    protected abstract T getBlob(byte[] var1);

    protected abstract T getString(String var1);

    protected abstract T getLong(long var1);

    protected abstract T getDouble(double var1);

    protected abstract T getBoolean(boolean var1);

    public static Object unpackObjectList(byte[] buffer, int offset, int length) throws AerospikeException {
        ObjectUnpacker unpacker = new ObjectUnpacker(buffer, offset, length);
        return unpacker.unpackList();
    }

    public static Object unpackObjectMap(byte[] buffer, int offset, int length) throws AerospikeException {
        ObjectUnpacker unpacker = new ObjectUnpacker(buffer, offset, length);
        return unpacker.unpackMap();
    }

    private static final class ObjectUnpacker
    extends Unpacker<Object> {
        public ObjectUnpacker(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        @Override
        protected Object getMap(Map<Object, Object> value) {
            return value;
        }

        @Override
        protected Object getList(List<Object> value) {
            return value;
        }

        @Override
        protected Object getJavaBlob(Object value) {
            return value;
        }

        @Override
        protected Object getBlob(byte[] value) {
            return value;
        }

        @Override
        protected Object getString(String value) {
            return value;
        }

        @Override
        protected Object getLong(long value) {
            return value;
        }

        @Override
        protected Object getDouble(double value) {
            return value;
        }

        @Override
        protected Object getBoolean(boolean value) {
            return value;
        }
    }
}

