/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

public final class ResultCode {
    public static final int COMMAND_REJECTED = -6;
    public static final int QUERY_TERMINATED = -5;
    public static final int SCAN_TERMINATED = -4;
    public static final int INVALID_NODE_ERROR = -3;
    public static final int PARSE_ERROR = -2;
    public static final int SERIALIZE_ERROR = -1;
    public static final int OK = 0;
    public static final int SERVER_ERROR = 1;
    public static final int KEY_NOT_FOUND_ERROR = 2;
    public static final int GENERATION_ERROR = 3;
    public static final int PARAMETER_ERROR = 4;
    public static final int KEY_EXISTS_ERROR = 5;
    public static final int BIN_EXISTS_ERROR = 6;
    public static final int CLUSTER_KEY_MISMATCH = 7;
    public static final int SERVER_MEM_ERROR = 8;
    public static final int TIMEOUT = 9;
    public static final int NO_XDS = 10;
    public static final int SERVER_NOT_AVAILABLE = 11;
    public static final int BIN_TYPE_ERROR = 12;
    public static final int RECORD_TOO_BIG = 13;
    public static final int KEY_BUSY = 14;
    public static final int SCAN_ABORT = 15;
    public static final int UNSUPPORTED_FEATURE = 16;
    public static final int BIN_NOT_FOUND = 17;
    public static final int DEVICE_OVERLOAD = 18;
    public static final int KEY_MISMATCH = 19;
    public static final int UDF_BAD_RESPONSE = 100;
    public static final int INDEX_FOUND = 200;
    public static final int INDEX_NOTFOUND = 201;
    public static final int INDEX_OOM = 202;
    public static final int INDEX_NOTREADABLE = 203;
    public static final int INDEX_GENERIC = 204;
    public static final int INDEX_NAME_MAXLEN = 205;
    public static final int INDEX_MAXCOUNT = 206;
    public static final int QUERY_ABORTED = 210;
    public static final int QUERY_QUEUEFULL = 211;
    public static final int QUERY_TIMEOUT = 212;
    public static final int QUERY_GENERIC = 213;

    public static boolean keepConnection(int resultCode) {
        switch (resultCode) {
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 202: 
            case 210: 
            case 212: {
                return false;
            }
        }
        return true;
    }

    public static String getResultString(int resultCode) {
        switch (resultCode) {
            case -6: {
                return "Command rejected";
            }
            case -5: {
                return "Query terminated";
            }
            case -4: {
                return "Scan terminated";
            }
            case -3: {
                return "Invalid node";
            }
            case -2: {
                return "Parse error";
            }
            case -1: {
                return "Serialize error";
            }
            case 0: {
                return "ok";
            }
            case 1: {
                return "Server error";
            }
            case 2: {
                return "Key not found";
            }
            case 3: {
                return "Generation error";
            }
            case 4: {
                return "Parameter error";
            }
            case 5: {
                return "Key already exists";
            }
            case 6: {
                return "Bin already exists";
            }
            case 7: {
                return "Cluster key mismatch";
            }
            case 8: {
                return "Server memory error";
            }
            case 9: {
                return "Timeout";
            }
            case 10: {
                return "XDS not available";
            }
            case 11: {
                return "Server not available";
            }
            case 12: {
                return "Bin type error";
            }
            case 13: {
                return "Record too big";
            }
            case 14: {
                return "Hot key";
            }
            case 15: {
                return "Scan aborted";
            }
            case 16: {
                return "Unsupported Server Feature";
            }
            case 17: {
                return "Bin not found";
            }
            case 18: {
                return "Device overload";
            }
            case 19: {
                return "Key mismatch";
            }
            case 100: {
                return "UDF returned error";
            }
            case 200: {
                return "Index already exists";
            }
            case 201: {
                return "Index not found";
            }
            case 202: {
                return "Index out of memory";
            }
            case 203: {
                return "Index not readable";
            }
            case 204: {
                return "Index error";
            }
            case 205: {
                return "Index name max length exceeded";
            }
            case 206: {
                return "Index count exceeds max";
            }
            case 210: {
                return "Query aborted";
            }
            case 211: {
                return "Query queue full";
            }
            case 212: {
                return "Query timeout";
            }
            case 213: {
                return "Query error";
            }
        }
        return "";
    }
}

