/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import java.util.HashMap;
import java.util.HashSet;

public final class AsyncBatchGetArray
extends AsyncMultiCommand {
    private final BatchNode.BatchNamespace batchNamespace;
    private final Policy policy;
    private final HashMap<Key, BatchItem> keyMap;
    private final Record[] records;
    private final int readAttr;

    public AsyncBatchGetArray(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batchNamespace, Policy policy, HashMap<Key, BatchItem> keyMap, HashSet<String> binNames, Record[] records, int readAttr) {
        super(parent, cluster, node, false, binNames);
        this.batchNamespace = batchNamespace;
        this.policy = policy;
        this.keyMap = keyMap;
        this.records = records;
        this.readAttr = readAttr;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchGet(this.batchNamespace, this.binNames, this.readAttr);
    }

    @Override
    protected void parseRow(Key key) throws AerospikeException {
        BatchItem item = this.keyMap.get(key);
        if (item != null) {
            if (this.resultCode == 0) {
                int index2 = item.getIndex();
                this.records[index2] = this.parseRecordWithDuplicates();
            }
        } else if (Log.debugEnabled()) {
            Log.debug("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest));
        }
    }
}

